#ifndef __ZVECTOR__
#define __ZVECTOR__

#include "intvector.h"

/* Uncomment next line to use floats instead of doubles */
// #define FLOATVECTOR */

#ifdef FLOATVECTOR
typedef struct { float re, im; } Cmplx;
#else
typedef struct { double re, im; } Cmplx;
#endif

typedef Cmplx*	ZVector;
typedef Cmplx	ZVectorType;
typedef Cmplx*	ZVectorTypePointer;
typedef Cmplx**	ZMatrix;
typedef Cmplx	ZMatrixType;
typedef Cmplx*	ZMatrixTypePointer;

typedef struct 
{
	ZMatrixTypePointer datastart;
	int n, m, rowpad;
} ZMatrixStubType;

#define ZMATRIXALIGN		32

#define ZMATRIXSTUBBLOCKS	(((sizeof(ZMatrixStubType)-1)/ZMATRIXALIGN)+1)
#define ZMATRIXSTUBINDICES	(((ZMATRIXALIGN*ZMATRIXSTUBBLOCKS-1)/ \
					sizeof(ZMatrixTypePointer))+1)
#define ZMATRIXVALUESPERBLOCK	(((ZMATRIXALIGN-1)/sizeof(ZMatrixType))+1)
#define ZMatrixStub(M)		((ZMatrixStubType *)(M-ZMATRIXSTUBINDICES))
#define constZMatrixStub(M)	((const ZMatrixStubType *)(M - \
					ZMATRIXSTUBINDICES))

#define ZVectorSize(v)   	(((int *)(v))[-1])
#define ZVectorlength(v) 	(((const int *)(v))[-1])

#define ZMatrixSize1(M)  	(constZMatrixStub((M))->n)
#define ZMatrixSize2(M)  	(constZMatrixStub((M))->m)
#define ZMatrixrowpad(M)		(constZMatrixStub((M))->rowpad)
#define ZMatrixstride(M)		(((M)[1]-(M)[0]))
#define ZMatrixrefcount(M)	(*((int *)((ZMatrixStub((M))->datastart)- \
					ZMATRIXVALUESPERBLOCK)))

#define newZMatrix(n, m)	newpaddedZMatrix((n), (m), 0)
#define refZMatrix(M)		refsubZMatrix((M), 0, 0, -1, -1)
#define ZVectorSizeSame(U, V)	(ZVectorlength((U)) == ZVectorlength((V)))

#define ZMatrixSizeSame(M, N)	((ZMatrixSize1((M)) == ZMatrixSize1((N))) && \
				 (ZMatrixSize2((M)) == ZMatrixSize2((N))))
#define ZMatrixissquare(M)	 (ZMatrixSize1((M)) == ZMatrixSize2((M)))

int gettotalZVectordata();

ZVector newZVector(int n);
void zeroZVector(ZVector v);
void fillZVector(ZVector v, double re, double im);
ZVector dupZVector(const ZVector v);
void deleteZVector(ZVector v);
int ZVectorisfinite(const ZVector v);
//double ZVectorconjdotZVector(const ZVector v1, const ZVector v2);
void subfromZVector(ZVector a, const ZVector b);
void addtoZVector(ZVector a, const ZVector b);
void addscaledZVectortoZVector(ZVector a, const ZVector b, 
	double re_scale, double im_scale);
ZVector addZVectors(const ZVector a, const ZVector b);
ZVector subZVectors(const ZVector a, const ZVector b);
void copytoZVector(ZVector a, const ZVector b);
void scaleZVector(ZVector v, double re, double im);
void biasZVector(ZVector v, double re, double im);
//void normalizeZVector(ZVector v);
void printZVector(const ZVector v);
void saveZVectorasascii(const ZVector v, const char *filename);
void saveZVectorasformattedascii(const ZVector v, const char *filename,
	const char *format);
ZVector ZVectorfromfile(const char *filename);
void ZVectorsavebinary(const ZVector v, const char *filename);
ZVector ZVectorloadbinary(const char *filename);
void ZVectormeanRMS(const ZVector v, double *mean, double *rms);
void rollZVector(ZVector v, int deltan);
int stringtoZVector(const char *str, ZVector v);
char *ZVectortostring(const ZVector v);
ZVector newZVectorfromstring(const char *str);
ZVector subZVector(const ZVector v, int n1, int n2);
void conjZVector(ZVector v);
double ZVectorsumsquares(const ZVector z);
double ZVectornormalize(ZVector z);

ZMatrix newpaddedZMatrix(int n, int m, int rowpad);
void deleteZMatrix(ZMatrix M);
ZMatrix refsubZMatrix(const ZMatrix M, int n1, int m1, int n2, int m2);
void zeroZMatrix(ZMatrix M);
ZMatrix dupZMatrix(const ZMatrix M);
void printZMatrix(const ZMatrix M);
ZMatrix repadZMatrix(const ZMatrix M, int pad);
void ZMatrixsavebinary(const ZMatrix M, const char *filename);
ZMatrix ZMatrixloadbinary(const char *filename);
void scaleZMatrix(ZMatrix M, double re, double im);
void addscaledZMatrixtoZMatrix(ZMatrix a, const ZMatrix b, double re,double im);
void biasZMatrix(ZMatrix M, double re, double im);
void addtoZMatrix(ZMatrix M, const ZMatrix N);
void multiplyZMatrixtoZVector(const ZMatrix M, ZVector V);
double ZMatrixgreatesteigenvector(const ZMatrix M, ZVector v, int niter);
void subfromZMatrix(ZMatrix M, const ZMatrix N);
ZMatrix addZMatrices(const ZMatrix M, const ZMatrix N);
void copytoZMatrix(ZMatrix M, const ZMatrix N);
void applyfunctoZMatrix(ZMatrix M, double (*func)(double x));
ZMatrix dupsubZMatrix(const ZMatrix M, int n1, int m1, int n2, int m2);
void copysubZMatrix(ZMatrix N, const ZMatrix M, int n1, int m1, int n2, int m2,
	int n3, int m3);
ZVector ZMatrixrow(const ZMatrix M, int row);
ZVector ZMatrixcolumn(const ZMatrix M, int column);
ZMatrix ZMatrixmultiply(const ZMatrix A, const ZMatrix B);
void copyZMatrixmultiply(ZMatrix C, const ZMatrix A, const ZMatrix B);
ZVector ZMatrixZVectormultiply(const ZMatrix M, const ZVector V);
ZMatrix rollZMatrix(const ZMatrix M, int delta_n, int delta_m);
void rollZMatrixinplace(ZMatrix M, int delta_n, int delta_m);
ZMatrix transposeZMatrix(const ZMatrix M);
void transposeZMatrixinplace(ZMatrix M);
ZMatrix conjZMatrix(const ZMatrix M);
void conjZMatrixinplace(const ZMatrix M);
int ZMatrixisHermitian(const ZMatrix M);

int Zlinearsolve(ZMatrix a, ZVector b);

#endif
