#ifndef __ZVECARRAY__
#define __ZVECARRAY__

#include "zvector.h"

typedef  ZVectorType** ZVecArray;

#define ZVecArraySize(a) (((int *)(a))[-1])

ZVecArray newZVecArray(int n);
ZVecArray newpopulatedZVecArray(int n, int m);
void zeroZVecArray(ZVecArray a);
void deleteZVecArray(ZVecArray a);
void deleteZVecArrayandZVectors(ZVecArray a);
ZVecArray dupZVecArray(const ZVecArray a);
ZVecArray dupZVecArrayandZVectors(const ZVecArray a);
void copytoZVecArray(ZVecArray dest, const ZVecArray src);
ZVecArray ZVecArraysubset(const ZVecArray a, int col, int ncol);
ZVecArray dupZVecArraysubset(const ZVecArray a, int col, int ncol);
ZVecArray dupZVecArrayrowsubset(const ZVecArray a, int row, int nrow);
int ZVecArrayZVectorSize(const ZVecArray a);
int ZVecArrayZVectorcolumns(const ZVecArray a);
ZVecArray ZVecArraydeletecolumn(ZVecArray a, int col);
ZVecArray ZVecArrayinsertcolumn(ZVecArray a, int col);
ZVecArray ZVecArrayappendcolumn(ZVecArray a);
ZVecArray ZVecArrayinsertZVector(ZVecArray a, ZVector v, int col);
ZVecArray ZVecArrayappendZVector(ZVecArray a, ZVector v);
ZVecArray ZVecArrayappendZVectors(ZVecArray a, ...);
ZVecArray appendtoZVecArray(ZVecArray a, ZVecArray b);
void ZVecArraysetcolumn(ZVecArray a, ZVector v, int col);
ZMatrix newZMatrixfromZVecArray(const ZVecArray a);
ZVecArray newZVecArrayfromZMatrix(const ZMatrix M);
ZVecArray ZVecArrayconcat(ZVecArray a, ZVecArray b);
ZVecArray ZVecArrayappendZVecArray(ZVecArray a, const ZVecArray b);
ZVecArray ZVecArrayappendZVecArrays(ZVecArray a, ...);
ZVecArray reduceZVecArraybymask(ZVecArray a, const intVector mask);
ZVecArray ZVecArrayfromfile(const char *filename, int mincols);
int ZVecArraytofile(const ZVecArray a, const char *filename, 
	const char *format);
void ZVecArrayresize(const ZVecArray a, int newsize);

/* arithmetic */
void scaleZVecArray(ZVecArray a, double re, double im);
void addtoZVecArray(ZVecArray a, const ZVecArray b);
ZVector ZVecArrayVectoraverage(const ZVecArray a);

#endif
