#ifndef __UVFITS__
#define __UVFITS__

#include "fitsbase.h"
#include "vector.h"

struct FQtable
{
	int nfreq;
	double *freq;
	float *bw;
	float *cw;
	int *sideband;
};

struct ANtable
{
	int nant;
	char **name;
};

struct _UVFits
{
	struct _Fits;
	struct FQtable fqtab;
	struct ANtable antab;
	int reclen;
	Vector t;
};


typedef struct _UVFits* UVFits;

/* underscored functions not for public use */
void _UVFitsconstructor(UVFits UV);
void _UVFitsdestructor(UVFits UV);

int UVFitsparseFQtable(UVFits UV);
int UVFitsparseANtable(UVFits UV);
int UVFitsgettimes(UVFits UV);

UVFits newUVFits();
UVFits openUVFits(const char *filename);
void deleteUVFits(UVFits UV);

#endif
