#include <stdio.h>
#include <glib.h>
#include <math.h>
#include "lapack.h"
#include "lapack-private.h"
#include "mathfunc.h"
#include "intvector.h"
#include "vector.h"

#define SIGN(a, b) ( (b)>=0 ? ( (a)>=0 ? (a) : -(a) ) : ((a)>=0 ? -(a) : (a)) )

SVD newSVD(int n, int m)
{
	int min = m;
	SVD svd;

	if(min > n) min = n;

	printf("New SVD :  %d x %d\n", m, n);

	svd = g_new(struct svd, 1);
	svd->U = newMatrix(n, n);
	svd->Vt = newMatrix(m, m);
	svd->S = newVector(min);

	return svd;
}

void deleteSVD(SVD svd)
{
	if(!svd) return;

	if(svd->U) deleteMatrix(svd->U);
	if(svd->Vt) deleteMatrix(svd->Vt);
	if(svd->S) deleteVector(svd->S);

	g_free(svd);
}

SVD SingularValueDecompose(const Matrix M)
{
	Matrix A;
	int m, n, min, lwork=-1, info;
	intVector iwork;
	Vector work;
	SVD svd;

	printf("Decomposing...\n");

	n = MatrixSize1(M);
	m = MatrixSize2(M);

	min = n;
	if(m < min) min = m;

	svd = newSVD(n, m);
	printVector(svd->S);
	iwork = newintVector(8*min);

	printf("m = %d n = %d min = %d\n", m, n, min);

	A = transposeMatrix(M);

	/* first determine work size */
	dgesdd_("A", &n, &m, A[0], &n, svd->S, svd->U[0], &n,
		svd->Vt[0], &m, svd->S, &lwork, iwork, &info);

	lwork = svd->S[0];

	printf("lwork = %d\n", lwork);

	if(info != 0) 
	{
		deleteSVD(svd);
		deleteMatrix(A);
		deleteintVector(iwork);
		fprintf(stderr, "SVDdecompose : dgesdd_ [1] failed with "
				"return value %d\n", info);
		return 0;
	}

	work = newVector(lwork);
	
	dgesdd_("A", &n, &m, A[0], &n, svd->S, svd->U[0], &n,
		svd->Vt[0], &m, work, &lwork, iwork, &info);

	deleteVector(work);
	deleteintVector(iwork);

	if(info != 0) 
	{
		deleteSVD(svd);
		deleteMatrix(A);
		fprintf(stderr, "SVDdecompose : dgesdd_ [2] failed with "
				"return value %d\n", info);
		return 0;
	}	

	transposeMatrixinplace(svd->U);
	transposeMatrixinplace(svd->Vt);

	return svd;
}
