#!/usr/bin/env python

from pdf import PDF
import sys
from string import find
import biggles


def makepdfplot(pdfs):
	P = biggles.FramedPlot()
	for p in pdfs:
		P.add(biggles.Curve(p.v, p.pdf))
	return P
	
def makesumpdfplot(pdfs, v0, dv, nsamp):
	print 'sum plot'
	X = []
	Y = []
	v = v0
	for i in range(0, nsamp):
		y = 0.0
		for p in pdfs:
			y = y + p.interp(v)
		X.append(v)
		Y.append(y)
		v = v + dv
	P = biggles.FramedPlot()
	P.add(biggles.Curve(X, Y))
	return P

def makeprodpdfplot(pdfs, v0, dv, nsamp):
	print 'prod plot'
	X = []
	Y = []
	v = v0
	for i in range(0, nsamp):
		y = 1.0
		for p in pdfs:
			y = y * p.interp(v)
		X.append(v)
		Y.append(y)
		v = v + dv
	P = biggles.FramedPlot()
	P.add(biggles.Curve(X, Y))
	return P



donorm = 0
dosum = 0
doprod = 0
delta = 0.5
num = 3000
	
pdfs = []

for a in sys.argv[1:]:
	if a[0] == '0':
		if len(pdfs) > 0:
			pdfs[-1].scale(float(a))
		print 'scale by ', float(a)
	else:
		p = PDF(a)
		p.norm()
		pdfs.append(p)
		print 'file ', a

if len(pdfs) < 1:
	print 'Usage: %s [-n] [-s] [-d<delta>] pdf1 [pdf1 [pdf3 [...]]]' \
		% sys.argv[0]
else:
	l = len(pdfs[0].pdf)
	for p in pdfs[1:]:
		if(p.v  != pdfs[0].v or \
		   p.dv != pdfs[0].dv or \
		   len(p.pdf) != l):
			exit()
		for i in range(0, l):
			pdfs[0].pdf[i] = pdfs[0].pdf[i] + p.pdf[i]

	pdfs[0].save('sum.pdf')
