#!/usr/bin/env python

from pdf import PDF
import sys
from string import find
import biggles

maxvalue = 1.0e50


def makepdfplot(pdfs):
	P = biggles.FramedPlot()
	for p in pdfs:
		P.add(biggles.Curve(p.v, p.pdf))
	return P
	
def makesumpdfplot(pdfs, v0, dv, nsamp):
	print 'sum plot'
	X = []
	Y = []
	v = v0
	for i in range(0, nsamp):
		y = 0.0
		for p in pdfs:
			y = y + p.interp(v)
		X.append(v)
		Y.append(y)
		v = v + dv
	P = biggles.FramedPlot()
	P.add(biggles.Curve(X, Y))
	return P

def makeprodpdfplot(pdfs, v0, dv, nsamp):
	print 'prod plot'
	X = []
	Y = []
	v = v0
	for i in range(0, nsamp):
		y = 1.0
		for p in pdfs:
			y = y * p.interp(v)
		X.append(v)
		Y.append(y)
		v = v + dv
	P = biggles.FramedPlot()
	P.add(biggles.Curve(X, Y))
	return P



donorm = 0
dosum = 0
doprod = 0
doacc = 0
delta = 0.5
num = 3000
files = []

xl = None
yl = None
tl = None
outps = None

for a in sys.argv[1:]:
	if a[0] == '-':
		if find(a[0:2], 'a') > 0:
			doacc = 1
		if find(a[0:2], 'n') > 0:
			donorm = 1
		if find(a[0:2], 's') > 0:
			dosum = 1
		if find(a[0:2], 'p') > 0:
			doprod = 1
		if (find(a[0:2], 'd') > 0 and len(a) > 2):
			delta = float(a[2:])
		if (find(a[0:2], 'm') > 0 and len(a) > 2):
			maxvalue = float(a[2:])
		if (find(a[0:2], 'N') > 0 and len(a) > 2):
			num = int(a[2:])
		if (find(a[0:2], 'x') > 0 and len(a) > 2):
			xl = a[2:]
		if (find(a[0:2], 'y') > 0 and len(a) > 2):
			yl = a[2:]
		if (find(a[0:2], 't') > 0 and len(a) > 2):
			tl = a[2:]
		if (find(a[0:2], 'o') > 0 and len(a) > 2):
			outps = a[2:]
	else:
		files.append(a);

if len(files) < 1:
	print 'Usage: %s [-n] [-s] [-m<max>] [-t<title>] [-x<xlabel>] [-y<ylabel>] [-d<delta>] pdf1 [pdf1 [pdf3 [...]]]' \
		% sys.argv[0]
else:
	pdfs = []
	for f in files:
		p = PDF(f)
		p.truncate(maxvalue)
		pk = p.peak()
		sig1 = p.shortestinterval(0.68268949)
		sig2 = p.shortestinterval(0.95449974)
		print f, sig2[0], sig1[0], pk, sig1[1], sig2[1]
		if donorm:
			p.norm()
		if doacc:
			p = p.accumulate()
		pdfs.append(p)

	if dosum == 1:
		P = makesumpdfplot(pdfs, 0.0, delta, num)
	else:
		if doprod == 1:
			P = makeprodpdfplot(pdfs, 0.0, delta, num)
		else:
			P = makepdfplot(pdfs)

	P.aspect_ratio = 0.618034
	P.xlabel = xl
	P.ylabel = yl
	P.title = tl
	P.show()
	P.save_as_img('gif', 500, 500, 'pdf.gif')
	if outps != None:
		P.save_as_eps(outps)
