#ifndef __PDF__
#define __PDF__

#include "vector.h"

struct _PDF
{
	Vector pdf;	/* The distance PDF values */
        double v0;	/* first sampled value */
        double dv;	/* sample granularity */
	double weight;	/* Weight -- this parameter is not saved! */
	char *name;	/* Again -- parameter not saved! */
};

typedef struct _PDF* PDF;

#define PDFsamples(p)	(Vectorlength((p)->pdf))

PDF newPDF(int nsamp);
void deletePDF(PDF p);
void blankPDF(PDF p);
void incPDF(PDF p, double v);
void savePDF(const PDF p, const char *filename);
PDF loadPDF(const char *filename);
double PDFarea(const PDF p, double v1, double v2);
double PDFtotalarea(const PDF p);
double PDFpeak(const PDF p, double v1, double v2);
double PDFsigmarange(const PDF p, double nsigma, double v1, double v2,
        double *x1, double *x2);
void scalePDF(PDF p, double factor);
void PDFaddscalar(PDF p, double scalar);
void PDFapplyfunction(PDF p, double (*func)(double x));
double normPDF(PDF p);
double PDFgetmin(const PDF p, double frac);
double PDFgetmax(const PDF p, double frac);
double interpolatePDF(const PDF p, double v);
double PDFminval(const PDF p);
double PDFmaxval(const PDF p);

#endif
