#ifndef __LU_H__
#define __LU_H__

#include "vector.h"
#include "intvector.h"

#define Matrixinverse(m) luinverse((m))
#define luinvert(m) luinverse((m))

/* How to effectively use LU decomp:
 *
 * (See numerical recipes for some details)
 *
 * For solving A x = b  (A NxN matrix, x an unknown N Vector, and b a known
 * 	N Vector)
 *
 * intVector index;
 * Vector x;
 * index = ludecompose(A);
 * x = lubacksub(A, index, b);
 *
 * Note that A has been messed up, so use dupMatrix to save a copy if needed
 *
 * For Matrix inversion:
 *
 * Ai = luinvert(A);
 *
 * For finding A^-1 B: 
 *
 * AiB = Matrixinvertmultiply(A, B)
 */

intVector ludecompose(Matrix a);
Vector lubacksub(const Matrix a, const intVector indx, const Vector B);
Matrix luinverse(const Matrix M);
double Matrixdeterminant(const Matrix M);
Matrix Matrixinvertmultiply(const Matrix A, const Matrix B);
Matrix Matrixpseudoinverse(const Matrix M);

#endif
