#ifndef __WFBLIB_LAPACK_H__
#define __WFBLIB_LAPACK_H__

#include "vector.h"
#include "zvector.h"
#include "vecarray.h"

#define Matrixinverse(M)	(MatrixLUinverse(M))
#define ZMatrixinverse(M)	(ZMatrixLUinverse(M))

/***** Real *****/
int nonsymeigensolve(const Matrix V, Vector REvals,
        Vector IMvals, Matrix vecs);

int MatrixLUinvert(Matrix M);
Matrix MatrixLUinverse(const Matrix M);

/* functions that use the above */
int expMatrix(Matrix M, double factor);
int powMatrix(Matrix M, double power);
Matrix Matrixpseudoinverse(const Matrix M);

/***** Complex *****/

ZMatrix ZMatrixLUdecomp(ZMatrix M);
int ZMatrixLUinvert(ZMatrix M);
ZMatrix ZMatrixLUinverse(const ZMatrix M);

/* set upper to 1 for the upper matrix.  otherwise lower is returned */
ZMatrix ZMatrixCholeskydecomp(ZMatrix M, int upper);
int ZMatrixCholeskyinvert(ZMatrix M);

/* set upper to invert an upper tri matrix.  otherwise lower */
int triZMatrixinvert(ZMatrix M, int upper);

/* compute eigenvalues and optionally eigenvectors of Hermitian matrix */
Vector ZMatrixEigenH(ZMatrix M, int vecs);


/* split off svd? */

struct svd
{
        Matrix U, Vt;
        Vector S;
};

typedef struct svd * SVD;


SVD newSVD(int n, int m);
void deleteSVD(SVD svd);
SVD SingularValueDecompose(const Matrix M);

#endif
