#ifndef __WFBLIB_LAPACK_PRIVATE_H__
#define __WFBLIB_LAPACK_PRIVATE_H__

#include "zvector.h"

/* double routines */

void dgeev_(char *jobvl, char *jobvr, int *N, double *A, int *LDA, 
	double *wr, double *wi, double *vl, int *ldvl, double *vr, 
	int *ldvr, double *work, int *lwork, int *info);

void dgetrf_(int *m, int *n, double *a, int *lda, int *ipiv, int *info);

void dgetri_(int *n, double *a, int *lda, int *ipiv, double *work,
	int *lwork, int *info);

void dgesdd_(char *jobz, int *m, int *n, double *a, int *lda, 
	double *s, double *u, int *ldu, double *vt, int *ldvt,
	double *work, int *lwork, int *iwork, int *info);

/* complex routines */

/* factor general complex matrix into LU */
void zgetrf_(int *m, int *n, ZMatrixType *a, int *lda, int *ipiv, int *info);

/* take LU decomp and return inverted matrix */
void zgetri_(int *n, ZMatrixType *a, int *lda, int *ipiv, ZMatrixType *work,
	int *lwork, int *info);

/* factor Hermitian Pos-def complex matrix into U^H U or L L^H */
void zpotrf_(char *uplo, int *n, ZMatrixType *a, int *lda, int *info);

/* invert Hermitian Pos-def complex matrix using Cholesky decomposition */
void zpotri_(char *uplo, int *n, ZMatrixType *a, int *lda, int *info);

/* invert triangular complex matrix */
void ztrtri_(char *uplo, char *unit, int *n, ZMatrixType *a, int *lda, 
	int *info);

/* hermitian eigenvalue/vector solver */
void zheev_(char *jobz, char *uplo, int *n, ZMatrixType *a, int *lda,
	double *v, ZMatrixType *work, int *lwork, double *rwork, int *info);

#endif
