#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "image-vector.h"

Image newImagefromMatrix(const Matrix M)
{
	Image im;
	int m, n, i, j;
	MatrixType min, max;

	n = MatrixSize1(M);
	m = MatrixSize2(M);

	im = newImage(m, n);

	Matrixminmax(M, &min, &max);

	for(i = 0; i < m; i++) for(j = 0; j < n; j++)
		im->data[j][i] = 255.0*(M[j][i]-min)/(max-min);
	
	return im;
}

Image newImagefromZMatrix(const ZMatrix M)
{
	Image im;
	int m, n, i, j;
	double min, max;

	n = MatrixSize1(M);
	m = MatrixSize2(M);

	im = newImage(2*m, n);

	min = max = M[0][0].re;
	for(i = 0; i < m; i++) for(j = 0; j < n; j++)
	{
		if(M[j][i].re > max) max = M[j][i].re;
		if(M[j][i].im > max) max = M[j][i].im;
		if(M[j][i].re < min) min = M[j][i].re;
		if(M[j][i].im < min) min = M[j][i].im;
	}

	for(i = 0; i < m; i++) for(j = 0; j < n; j++)
	{
		im->data[j][2*i] = 255.0*(M[j][i].re-min)/(max-min);
		im->data[j][2*i+1] = 255.0*(M[j][i].im-min)/(max-min);
	}

	return im;
}

Matrix newMatrixfromImage(const Image im)
{
	Matrix M;
	int m, n, i, j;
	m = im->xres;
	n = im->yres;

	M = newMatrix(n, m);
	for(i = 0; i < m; i++) for(j = 0; j < n ; j++) 
		M[j][i] = im->data[j][i]/255.0;
	
	return M;
}

void saveMatrixaspgm(const Matrix M, const char *filename)
{
	Image I;

	g_assert(M);
	I = newImagefromMatrix(M);
	saveImageaspgm(I, filename);
	deleteImage(I);
}

void saveZMatrixaspgm(const ZMatrix M, const char *filename)
{
	Image I;

	g_assert(M);
	I = newImagefromZMatrix(M);
	saveImageaspgm(I, filename);
	deleteImage(I);
}

void saveMatrixasimage(const Matrix M, const char *filename)
{
	FILE *in;
	int i;
	char rnd[16];
	char tmpfile[256];
	char command[500];

	in = fopen("/dev/random", "r");
	for(i = 0; i < 15; i++) rnd[i] = 'A'+(fgetc(in)/10);
	fclose(in);
	rnd[15] = 0;

	sprintf(tmpfile, "/tmp/%s.pgm", rnd);
	saveMatrixaspgm(M, tmpfile);
	sprintf(command, "convert %s %s", tmpfile, filename);
	system(command);
	sprintf(command, "rm -f %s", tmpfile);
	system(command);
}

void saveZMatrixasimage(const ZMatrix M, const char *filename)
{
	FILE *in;
	int i;
	char rnd[16];
	char tmpfile[256];
	char command[500];

	in = fopen("/dev/random", "r");
	for(i = 0; i < 15; i++) rnd[i] = 'A'+(fgetc(in)/10);
	fclose(in);
	rnd[15] = 0;

	sprintf(tmpfile, "/tmp/%s.pgm", rnd);
	saveZMatrixaspgm(M, tmpfile);
	sprintf(command, "convert %s %s", tmpfile, filename);
	system(command);
	sprintf(command, "rm -f %s", tmpfile);
	system(command);
}

/* Note -- this doesn't blank the pad */
Matrix newpaddedMatrixfromImage(const Image im, int rowpad)
{
	Matrix M;
	int m, n, i, j;
	m = im->xres;
	n = im->yres;

	M = newpaddedMatrix(n, m, rowpad);
	for(i = 0; i < m; i++) for(j = 0; j < n ; j++) 
		M[j][i] = im->data[j][i]/255.0;
	
	return M;
}
