#ifndef __FITSBASE__
#define __FITSBASE__

/* basic fits io.  for specialization for uvfits data, use uvfits.h */

#include "keyvalue.h"

extern int FitsSwapBytes;

void Fitsinit();

struct axis
{
	int n;
	const char *ctype;
	double crval, crpix, cdelt, crota;
};

struct column
{
	const char *ttype;
	const char *tunit;
	const char *tformat;
};

struct pinfo
{
	double pscale, pzero;
	const char *ptype;
};

struct _FitsTable
{
	struct KeyValue *kv;
	char *base;
	void *data;
	int bitpix;
	int length;
	char *name;
	int extver;
	int naxes;
	struct axis *axes;
	int pcount;
	struct pinfo *pdata;
	int gcount;
	int tfields;
	struct column *columns;
}; 

typedef struct _FitsTable *FitsTable;

FitsTable newFitsTable();
FitsTable newFitsTablefromdata(char *data);
void deleteFitsTable(FitsTable T);
int FitsTableaddkv(FitsTable T, char *line);
int FitsTablegetaxes(FitsTable T);
int FitsTablegetcolumns(FitsTable T);
int FitsTablegetpdata(FitsTable T);

int FitsTabletypeoffset(const FitsTable T, const char *type, char form,
	int *num);
double *FitsTablegetdatadouble(const FitsTable T, const char *type, int row,
	int *num);
float *FitsTablegetdatafloat(const FitsTable T, const char *type, int row,
	int *num);
int *FitsTablegetdataint(const FitsTable T, const char *type, int row,
	int *num);
char *FitsTablegetdatachar(const FitsTable T, const char *type, int row,
	int *num);

int FitsTablegetaxisinfo(const FitsTable T, const char *type, int *axislen,
	double *crval, double *cdelt, double *crpix, double *crota);

struct _Fits
{
	void *start, *data;
	int fd, length, ntables;
	FitsTable *tables;
};

typedef struct _Fits* Fits;

/* underscored functions not for public use */
void _Fitsconstructor(Fits F);
void _Fitsdestructor(Fits F);
int _Fitsopen(Fits F, const char *filename);

Fits newFits();
void deleteFits(Fits F);
Fits openFits(const char *filename);

int FitsappendTable(Fits F, FitsTable T);
void FitsdeleteallTables(Fits F);

FitsTable FitsgetFitsTablebyname(Fits F, const char *name, int version);

#endif /* __FITSBASE__ */
