#include "fits.h"
#include <glib.h>
#include <cfitsio/fitsio.h>

int Matrixtofits(const Matrix M, const char *filename, int datatype)
{
	fitsfile *fptr;
	int status;
	int m, n, j, i;
	long naxes[2];
	long fpixel = 1;
	unsigned char *ucarray;
	short *sarray;
	long *larray;
	float *farray;
	double *darray;
	
	g_assert(M);
	m = MatrixSize1(M);
	n = MatrixSize2(M);
	
	naxes[0] = n;
	naxes[1] = m;
	
	status = 0;
	fits_create_file(&fptr, filename, &status);

	fits_create_img(fptr, datatype, 2, naxes, &status);
	switch(datatype)
	{
		case BYTE_IMG:
			ucarray = g_new(unsigned char, m*n);
			for(j = 0; j < n; j++) for(i = 0; i < m; i++)
				ucarray[j*m+i] = M[j][i];
			fits_write_img(fptr, TBYTE, fpixel,
				m*n, ucarray, &status);
			g_free(ucarray);
		case SHORT_IMG:
			sarray = g_new(short, m*n);
			for(j = 0; j < n; j++) for(i = 0; i < m; i++)
				sarray[j*m+i] = M[j][i];
			fits_write_img(fptr, TSHORT, fpixel,
				m*n, sarray, &status);
			g_free(sarray);
		case LONG_IMG:
			larray = g_new(long, m*n);
			for(j = 0; j < n; j++) for(i = 0; i < m; i++)
				larray[j*m+i] = M[j][i];
			fits_write_img(fptr, TLONG, fpixel,
				m*n, larray, &status);
			g_free(larray);
		case FLOAT_IMG:
			farray = g_new(float, m*n);
			for(j = 0; j < n; j++) for(i = 0; i < m; i++)
				farray[j*m+i] = (int)(M[j][i]);
			fits_write_img(fptr, TFLOAT, fpixel,
				m*n, farray, &status);
			g_free(farray);
		case DOUBLE_IMG:
			darray = g_new(double, m*n);
			for(j = 0; j < n; j++) for(i = 0; i < m; i++)
				darray[j*m+i] = (int)(M[j][i]);
			fits_write_img(fptr, TDOUBLE, fpixel,
				m*n, darray, &status);
			g_free(darray);
/*
		case LONGLONG_IMG:
		case USHORT_IMG:
		case ULONG_IMG:
*/
	}	
	
	fits_close_file(fptr, &status);

	return 0;
}
