#ifndef __EIGEN_H__
#define __EIGEN_H__

#include "vector.h"
#include "vecarray.h"

void nonsymeigensolve(const Matrix V, Vector REvals,
        Vector IMvals, Matrix vecs);

void MatrixLUinvert(Matrix M);

void expMatrix(Matrix M, double factor);

void powMatrix(Matrix M, double power);

typedef struct
{
	VectorTypePointer a, b;
	int length;
} tridiag;

tridiag *newtridiag(int L);
void deletetridiag(tridiag *t);

tridiag *householder(Matrix a);
int tridiag_solve(tridiag *t, Vector v, Vector b);
void tridiag_eigen(tridiag *t, int n, Vector v, VecArray vecs);
void symmetric_eigen(const Matrix m, int n, Vector v, VecArray vecs);
Vector maximize_quadratic_ratio(const Matrix A, const Matrix B);
Vector maximize_quadratic_ratio2(const Matrix A, const Matrix B, int niter,
        const Vector w0);
void quadratic_ratio_solve(const Matrix A, const Matrix B, Vector vals,
	VecArray vecs);

#endif
