#ifndef __ERRORBAR_H__
#define __ERRORBAR_H__

#include "vector.h"

/* major, minor Axes are semi-axis diameters */

struct _ErrorEllipse
{

/* Elliptical Parameters */
	double major, minor, angle;	/* angle : rad. clockwise from y axis */
	
/* Variances */
	double sigxx, sigyy, sigxy;	/* variances, covariance */

};

typedef struct _ErrorEllipse * ErrorEllipse;

ErrorEllipse newErrorEllipse(double major, double minor, double angle);
ErrorEllipse newErrorEllipsefromvariances(
			     double sigxx, double sigyy, double sigxy);
ErrorEllipse dupErrorEllipse(const ErrorEllipse ee);
void deleteErrorEllipse(ErrorEllipse ee);
void printErrorEllipse(const ErrorEllipse ee);
void convolveErrorEllipse(ErrorEllipse ee1, const ErrorEllipse ee2);
void deconvolveErrorEllipse(ErrorEllipse ee1, const ErrorEllipse ee2);
void bwsmearErrorEllipse(ErrorEllipse ee, double D, double x, double y, double freq, double bw);
void rotateErrorEllipse(ErrorEllipse ee, double angle);
double ErrorEllipsearea(const ErrorEllipse ee);
void renderErrorEllipsetoMatrix(const ErrorEllipse ee, Matrix M,
        double dx, double dy, double scale);
void rendersolidErrorEllipsetoMatrix(const ErrorEllipse ee, Matrix M,
        double dx, double dy, double scale);

#endif
