#ifndef __CUBE__
#define __CUBE__

#include "vector.h"

#ifdef FLOATVECTOR
typedef  float*** Cube;
typedef  float    CubeType;
typedef  float*   CubeTypePointer;
#else
typedef double*** Cube;
typedef double    CubeType;
typedef double*   CubeTypePointer;
#endif

typedef struct
{
	CubeTypePointer datastart;
	int n1, n2, n3, stride2, stride3;
} CubeStubType;

#define CUBEALIGN		32

#define CUBESTUBBLOCKS		(((sizeof(CubeStubType)-1)/CUBEALIGN)+1)
#define CUBESTUBINDICES		(((CUBEALIGN*CUBESTUBBLOCKS-1)/ \
					sizeof(CubeTypePointer))+1)
#define CUBEVALUESPERBLOCK	(((CUBEALIGN-1)/sizeof(CubeType))+1)
#define CubeStub(C)		((CubeStubType *)(C-CUBESTUBINDICES))
#define constCubeStub(C)	((const CubeStubType *)(C-CUBESTUBINDICES))

#define CubeSize1(C)		(constCubeStub((C))->n1)
#define CubeSize2(C)		(constCubeStub((C))->n2)
#define CubeSize3(C)		(constCubeStub((C))->n3)
#define Cubestride2(C)		(constCubeStub((C))->stride2)
#define Cubestride3(C)		(constCubeStub((C))->stride3)
#define Cuberefcount(C)		(*((int *)((CubeStub((C))->datastart)- \
					CUBEVALUESPERBLOCK)))

#define CubeSizeSame(C, D)	((CubeSize1((C)) == CubeSize1((D))) && \
				 (CubeSize2((C)) == CubeSize2((D))) && \
				 (CubeSize3((C)) == CubeSize3((D))))

#define newCube(n1, n2, n3)	newstridedCube((n1), (n2), (n3), (n2), (n3))

Cube newstridedCube(int n1, int n2, int n3, int stride2, int stride3);
Cube refsubCube(const Cube C, int a1, int a2, int a3, int b1, int b2, int b3);
void deleteCube(Cube C);

void zeroCube(Cube C);
Cube dupCube(Cube C);

Matrix Cubeslice1(const Cube C, int s1);
Matrix Cubeslice2(const Cube C, int s2);
Matrix Cubeslice3(const Cube C, int s3);

CubeType Cubemaxvalue(const Cube C, int *a, int *b, int *c);
CubeType Cubeminvalue(const Cube C, int *a, int *b, int *c);
Matrix Cubepeakup(const Cube C, int x1, int x2, int x3, int p1, int p2, int p3,
	double *y1, double *y2, double *y3, double *peak);

#endif
