#include <math.h>
#include "astrometry.h"
#include <glib.h>

void coordconv(double ai, double bi, double *ao, double *bo, int mode)
{
	double a, b, cb, sb, cbsa;
	const double psi[12] = 
	{
		0.57477043300, 4.9368292465, 
		0.00000000000, 0.0000000000,  
		0.11142137093, 4.71279419371,    
  		0.57595865315, 4.9261918136,
		0.00000000000, 0.0000000000,  
		0.11129056012, 4.7005372834
	};   
	const double stheta[12] =
	{
		0.88998808748, -0.88998808748,
		0.39777715593, -0.39777715593,
		0.86766622025, -0.86766622025,    
		0.88781538514, -0.88781538514,
		0.39788119938, -0.39788119938,
		0.86766174755, -0.86766174755
	};
	const double ctheta[12] =
	{
		0.45598377618, 0.45598377618,
		0.91748206207, 0.91748206207,
		0.49714719172, 0.49714719172,   
		0.46019978478, 0.46019978478,
		0.91743694670, 0.91743694670,
		0.49715499774, 0.49715499774
	};
	const double phi[12] = 
	{	
		4.9368292465,  0.57477043300,
		0.0000000000,  0.00000000000,
		4.71279419371, 0.11142137093,
		4.9261918136,  0.57595865315,
		0.0000000000,  0.00000000000,
		4.7005372834,  0.11129056012
	};

	if(mode < 0 || mode >= 12)
	{
		*ao = ai;
		*bo = bi;
		return;
	}

	a = ai - phi[mode];
	sb = sin(bi);
	cb = cos(bi);
	cbsa = cb*sin(a);
	b = -stheta[mode]*cbsa + ctheta[mode]*sb;
	*bo = asin(b);
	a = atan2(ctheta[mode]*cbsa + stheta[mode]*sb, cb*cos(a));
	*ao = a + psi[mode];
	while(*ao >= 2.0*M_PI) *ao -= 2.0*M_PI;
	while(*ao < 0.0) *ao += 2.0*M_PI;
}

double coordconvangle(double ai, double bi, int mode)
{
	const double eps = 1.0e-7;
	double a1, a2, b1, b2;

	coordconv(ai, bi, &a1, &b1, mode);
	coordconv(ai+eps, bi, &a2, &b2, mode);

	return atan2(b2-b1, a2-a1);
}
