#include <stdio.h>
#include <wfblib/vector.h>
#include <wfblib/zvector.h>
#include <wfblib/randdist.h>
#include <wfblib/lapack.h>

int main()
{
	ZVector a, b, c;
	ZMatrix A, B, C, D, E, F, G, H, I;
	int i, j;
	Matrix M;

	M = newMatrix(3,3);
	zeroMatrix(M);
	M[0][0] = 1.0;
	M[1][2] = -1.0;
	M[2][1] = 1.0;
	printMatrix(M);
	expMatrix(M, 1);
	printMatrix(M);
	deleteMatrix(M);
	

	a = newZVector(10);
	fillZVector(a, 1, 2);
	a[2].re = 5;
	a[3].im = 5;
	printf("a = "); printZVector(a);

	b = dupZVector(a);
	conjZVector(b);
	printf("b = "); printZVector(b);

	c = subZVector(b, 1, 8);
	printf("c = "); printZVector(c);

	scaleZVector(c, 1.0, 1.0);
	printf("c = "); printZVector(c);

	printf("Allocated z vector data : %d\n", gettotalZVectordata());

	deleteZVector(a);
	deleteZVector(b);
	deleteZVector(c);

	printf("Allocated z vector data : %d\n", gettotalZVectordata());

	c = newZVector(3);
	zeroZVector(c);
	
	c[0].re = 1.0;
	c[1].im = 0.5;
	c[2].re = 2.0;
	c[2].im = -0.25;

	A = newZMatrix(3, 3);
	zeroZMatrix(A);

	for(i = 0; i < 3; i++) for(j = 0; j < 3; j++)
	{
		A[j][i].re = rand_gauss()*2.5;
		A[j][i].im = rand_gauss()*1.5;
	}

	B = conjZMatrix(A);
	transposeZMatrixinplace(B);

	C = ZMatrixmultiply(B, A);
	
	printf("A = "); printZMatrix(A);
	printf("B = "); printZMatrix(B);
	printf("C = "); printZMatrix(C);

	printf("c = "); printZVector(c);
	multiplyZMatrixtoZVector(A, c);
	printf("c = "); printZVector(c);
	multiplyZMatrixtoZVector(A, c);
	printf("c = "); printZVector(c);

	deleteZMatrix(B);
	deleteZMatrix(C);

	B = dupZMatrix(A);
	ZMatrixLUinvert(B);
	C = ZMatrixmultiply(B, A);
	
	printf("Complex matrix inversion test:\n");
	printf("A = "); printZMatrix(A);
	printf("B = "); printZMatrix(B);
	printf("C = "); printZMatrix(C);

	deleteZMatrix(B);
	deleteZMatrix(C);
	
	for(i = 0; i < 3; i++) 
	{
		A[i][i].re += 6.0;
		A[i][i].im = 0.0;
	}
	for(j = 1; j < 3; j++) for(i = 0; i < j; i++)
	{
		A[i][j].re =  A[j][i].re;
		A[i][j].im = -A[j][i].im;
	}

	B = ZMatrixCholeskydecomp(A, 0);
	C = ZMatrixCholeskydecomp(A, 1);
	E = dupZMatrix(B);
	F = dupZMatrix(C);
	triZMatrixinvert(E, 0);
	triZMatrixinvert(F, 1);
	G = ZMatrixmultiply(F, E);
	H = ZMatrixmultiply(B, E);
	I = ZMatrixmultiply(C, F);

	printf("tri invert\n");
	printf("E = "); printZMatrix(E);
	printf("F = "); printZMatrix(F);
	printf("G = "); printZMatrix(G);
	printf("H = "); printZMatrix(H);
	printf("I = "); printZMatrix(I);

	deleteZMatrix(E);
	deleteZMatrix(F);
	deleteZMatrix(G);
	
//	C = conjZMatrix(B);
//	transposeZMatrixinplace(C);
	D = ZMatrixmultiply(B, C);

	printf("Cholesky decomp\n");
	printf("A = "); printZMatrix(A);
	printf("B = "); printZMatrix(B);
	printf("C = "); printZMatrix(C);
	printf("D = "); printZMatrix(D);
	
	deleteZMatrix(B);
	deleteZMatrix(C);

	B = dupZMatrix(A);
	ZMatrixCholeskyinvert(B);
	C = ZMatrixmultiply(B, A);

	printf("Cholesky invert\n");
	printf("A = "); printZMatrix(A);
	printf("B = "); printZMatrix(B);
	printf("C = "); printZMatrix(C);
	
	deleteZMatrix(A);
	deleteZMatrix(B);
	deleteZMatrix(C);
	deleteZVector(c);

	M = newMatrix(2, 4);
	for(i = 0; i < 4; i++) for(j = 0; j < 2; j++) M[j][i] = rand_gauss();
	
	printf("Matrix binary save and ZMatrix load test\n");
	printf("M = "); printMatrix(M);
	Matrixsavebinary(M, "M.bin");
	A = ZMatrixloadbinary("M.bin");
	printf("A = "); printZMatrix(A);

	deleteMatrix(M);
	deleteZMatrix(A);

	a = newZVector(2);
	zeroZVector(a);
	a[0].re = 1.0;
	a[1].im = -1.0;

	A = newZMatrix(2, 2);
	zeroZMatrix(A);
	A[0][0].re = 1.0;  A[1][1].re = 1.0;
	A[1][0].re = 0.1;  A[0][1].im = -0.1;

	printf("multiplyZMatrixtoZVector test\n");
	printf("A = "); printZMatrix(A);

	for(i = 0; i < 10; i++)
	{
		printf("a = "); printZVector(a);
		multiplyZMatrixtoZVector(A, a);
	}

	printf("a = "); printZVector(a);

	deleteZMatrix(A);
	deleteZVector(a);

	return 0;
}
