#include <stdio.h>
#include <wfblib/lapack.h>
#include <wfblib/randdist.h>

int main()
{
	SVD s;
	int i, n, j, m, min;
	Matrix M, w, a, b;

	m = 6;
	n = 5;

	min = m; 
	if(n < min) min = n;


	M = newMatrix(n, m);
//	M[0][0] = 1.2;
//	M[1][0] = 0.5;
//	M[0][1] = -0.3;
//	M[1][1] = 0.9;

	for(j = 0; j < n; j++) for(i = 0; i < m; i++) 
		M[j][i] = 0.05*rand_pm_one();
	for(j = 0; j < min; j++) 
		M[j][j] += 1+j;

	printf("about to decompose\n");
	s = SingularValueDecompose(M);

//	transposeMatrixinplace(s->U);
//	transposeMatrixinplace(s->Vt);

	printf("M: ");
	printMatrix(M);
	printf("U: ");
	printMatrix(s->U);
	printf("Vt: ");
	printMatrix(s->Vt);
	printf("S: ");
	printVector(s->S);

	w = newMatrix(n, m);
	zeroMatrix(w);
	for(i = 0; i < n; i++) w[i][i] = s->S[i];

	a = Matrixmultiply(s->U, w);
	b = Matrixmultiply(a, s->Vt);

	printf("U S Vt: ");
	printMatrix(b);

	subfromMatrix(M, b);
	printf("M - U S Vt: ");
	printMatrix(M);

//	for(i = 0; i < n; i++) X[i] = rand_pm_one();
//	B = MatrixVectormultiply(M, X);

//	printf("X: ");
//	printVector(X);
//	printf("B: ");
//	printVector(B);

//	for(i = 0; i < VectorSize(B); i++) B[i] += rand_pm_one()*0.002;
//	printf("B: ");
//	printVector(B);


//	Y = SVDbacksub(s, B);
//	printf("Y: ");
//	printVector(Y);

	return 0;
}
