#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/randdist.h>
#include <wfblib/vector-fftw.h>
#include <wfblib/vecarray.h>

int main()
{
	VecArray A;
	Vector V;
	int i;

	V = newVector(1000);
	zeroVector(V);
	for(i = 600; i < 700; i++) V[i] = 0.5*rand_gauss() + 2.0;
	for(i = 850; i < 900; i++) V[i] = 3.0;
	for(i = 50; i < 70; i++) V[i] += 2.0;
	V[100] = 5.0;
	V[400] = 20.0;

	A = VecArrayappendVector(0, V);
	A = VecArrayappendVector(A, dupVector(V));
	A = VecArrayappendVector(A, dupVector(V));
	A = VecArrayappendVector(A, dupVector(V));
	A = VecArrayappendVector(A, dupVector(V));
	A = VecArrayappendVector(A, dupVector(V));
	
	smoothVector(A[1], 20.0, SMOOTH_GAUSS);
	smoothVector(A[2], 20.0, SMOOTH_COS);
	smoothVector(A[3], 20.0, SMOOTH_COS1);
	smoothVector(A[4], 20.0, SMOOTH_BOX);
	smoothVector(A[5], 20.0, SMOOTH_TRIANGLE);
	
	VecArraytofile(A, "smooth.out", "%f");

	deleteVecArrayandVectors(A);
	
	return 0;
}
