#include <stdio.h>
#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/vecarray.h>
#include <wfblib/mathfunc.h>
#include <wfblib/randdist.h>

int main()
{
	Vector V, x, y;
	int i, n = 3000;
	double m = 0.001;
	double sigma = 0.001;
	double m0 = 0.0, m2 = 0.0, m4 = 0.0;
	double a4, a, s;
	VecArray A;

	A = newpopulatedVecArray(3, n);
	for(i = 0; i < n; i++)
	{
		A[0][i] = 5.0*i/n;
		A[1][i] = log(bessel_I0(A[0][i]));
		A[2][i] = log(bessel_I1(A[0][i]));
	}
	VecArraytofile(A, "bessel2.out", "%f");
	deleteVecArrayandVectors(A);
	
	V = newVector(n);

	for(i = 0; i < n; i++) V[i] = rand_rice(m, sigma);
	
	for(i = 0; i < n; i++)
	{
		m0 += 1.0;
		m2 += V[i]*V[i];
		m4 += V[i]*V[i]*V[i]*V[i];
	}

	m2 /= m0;
	m4 /= m0;

	printf("m2 = %f\n", m2);
	printf("m4 = %f\n", m4);

	a4 = 2.0*m2*m2 - m4;

	printf("a4 = %f\n", a4);
	a = sqrt(sqrt(fabs(a4)));
	printf("amp   = %f\n", a);
	s = sqrt(0.5*(m2-a*a));
	printf("sigma = %f\n", s);

	for(i = 0; i < 5; i++)
		printf("M%d : %f %f\n", i,
			rice_moment(m, sigma, i), Vectormoment(V, i)/n);

	printf("True   m = %f, sigma = %f\n", m, sigma);

	x = newVector(n);
	y = newVector(n);
	for(i = 0; i < n; i++)
	{
		x[i] = sigma*rand_gauss() + m;
		y[i] = sigma*rand_gauss();
	}
	rice_params2(x, y, &m, &sigma);
	printf("Fit2   m = %f, sigma = %f\n", m, sigma);
	rice_params2a(x, y, &m, &sigma);
	printf("Fit2a  m = %f, sigma = %f\n", m, sigma);
	rice_params2(x, y, &m, &sigma);
	printf("Fit2   m = %f, sigma = %f\n", m, sigma);



	deleteVector(V);



	return 0;
}
