#include <stdio.h>
#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/randdist.h>

void randtest()
{
	int i;
	
	printf("20 random doubles:\n");
	for(i = 0; i < 5; i++) printf("%f %f %f %f\n",
		rand_one(),
		rand_one(),
		rand_one(),
		rand_one());
	printf("20 random pm1 doubles:\n");
	for(i = 0; i < 5; i++) printf("%f %f %f %f\n",
		rand_pm_one(),
		rand_pm_one(),
		rand_pm_one(),
		rand_pm_one());
	printf("20 random gaussian doubles:\n");
	for(i = 0; i < 5; i++) printf("%f %f %f %f\n",
		rand_gauss(),
		rand_gauss(),
		rand_gauss(),
		rand_gauss());
}

int main()
{
	Vector V;
	int i, j, N;
	double ac, as;

	N = 512;

	randtest();

	V = newVector(N);
	zeroVector(V);
	for(j = 1; j < 10; j++)
	{
		ac = exp(-j*j/50.0)*rand_gauss();
		as = exp(-j*j/50.0)*rand_gauss();
		for(i = 0; i < N; i++) V[i] += ac*cos(i*j*2.0*M_PI/N);
		for(i = 0; i < N; i++) V[i] += ac*sin(i*j*2.0*M_PI/N);
	}

	saveVectorasascii(V, "r.out");

	deleteVector(V);

	return 0;
}
