#include <stdio.h>
#include <stdlib.h>
#include <stdlib.h>
#include <time.h>
#include <wfblib/vector.h>
#include <wfblib/randdist.h>

int main(int argc, char **argv)
{
	int n, i, j;
	Vector B, x;
	Matrix A;

	if(argc < 2) n = 5;
	else n = atoi(argv[1]);

	srand(time(0));
	
	B = newVector(n);
	
	for(i = 0; i < n; i++) B[i] = rand_gauss();
	printf("B = "); printVector(B);

	
	printf("n = %d\n", n);
	A = newMatrix(n, n);

	for(i = 0; i < n; i++) for(j = 0; j < i; j++)
		A[i][j] = A[j][i] = rand_pm_one();
		
	for(i = 0; i < n; i++) A[i][i] = rand_pm_one() + 2.0*n;
	

	x = cholesky(A, B);
	if(x == 0)
	{
		printf(" bad values. try again\n");
		return 0;
	}

	printf("x = "); printVector(x);

	printf("Gauss Jordan:\n");

	gaussjordan(A, B);

	printf("x = "); printVector(B);

	deleteMatrix(A);
	deleteVector(B);
	deleteVector(x);

	A = newMatrix(2, 2);
	A[0][0] = 0.0;
	A[1][0] = 1.0;
	A[0][1] = 1.0;
	A[1][1] = 0.0;
	B = newVector(2);
	B[0] = 4;
	B[1] = 12;
	x = cholesky(A, B);
	printVector(x);

	deleteMatrix(A);
	deleteVector(B);
	deleteVector(x);

	return 0;
}
