#include <stdio.h>
#include <wfblib/vector.h>
#include <wfblib/image.h>
#include <wfblib/image-vector.h>
#include <wfblib/vector-fftw.h>

/* This produces an image called testimage.pgm containing a gaussian-shaped 
   lump */

#define Nx	200
#define Ny	250

int main()
{
	Matrix M;
	Matrix N;
	Matrix O;
	Matrix P;
	Image I;
	int i, j, k, l;
	double x, y;

	M = newMatrix(Ny, Nx);

	for(j = 0; j < Ny; j++) for(i = 0; i < Nx; i++)
	{
		x = (i-Nx/2)/40.0;
		y = (j-Ny/2)/40.0;
		M[j][i] = -(x*x + y*y);
	}

	N = refMatrix(M);
	O = refsubMatrix(N, 10, 10, 50, 50);

	P = refsubMatrix(O, 15, 15, 20, 20);
	zeroMatrix(P);

	//MatrixFFTrows(O, FFTW_FORWARD);
	//MatrixFFTcolumns(O, FFTW_FORWARD);
	scaleMatrix(O, 0.7);

	I = newImagefromMatrix(M);
	saveImageaspgm(I, "testimage.pgm");
	deleteImage(I);

	deleteMatrix(M);
	deleteMatrix(N);
	deleteMatrix(P);
	deleteMatrix(O);

	M = newMatrix(111, 111);
	zeroMatrix(M);
	
	for(j = 0; j < 10; j++) for(i = 0; i < 10; i++)
	{
		N = refsubMatrix(M, j*11+1, i*11+1, j*11+10, i*11+10);
		for(l = 0; l < 10; l++) for(k = 0; k < 10; k++)
			N[l][k] = l+k+4;
		rollMatrixinplace(N, j, i);
		deleteMatrix(N);
	}
	
	I = newImagefromMatrix(M);
	saveImageaspgm(I, "roll.pgm");
	deleteImage(I);
	deleteMatrix(M);
	
	return 0;
}
