#include <stdio.h>
#include <math.h>
#include <wfblib/mathfunc.h>
#include <wfblib/vector.h>
#include <wfblib/vecarray.h>

double x_t = 1.0;
double y_t = 0.0;
double A_t = 1.0;
double x_c = -1.0;
double y_c = 0.0;
double A_c = 1.0;
double sigma1 = 1.0;
double sigma2 = 1.0;

int main()
{
	int i, j;
	double goal;
	VecArray a;
	double E, F, theta, P;
	
	a = newpopulatedVecArray(5, 1000);
	for(i = 0; i < 1000; i++)
	{
		theta = 2.0*M_PI*i/1000.0;
		a[0][i] = theta;
		E = A_t*x_t + A_c*(x_c*cos(theta)-y_c*sin(theta));
		F = A_t*y_t + A_c*(x_c*sin(theta)+y_c*cos(theta));
		P = bessel_I0(sqrt(E*E + F*F)/(sigma1*sigma1));
		a[1][i] = P;
	}
	x_t = A_t = 10.0;
	for(i = 0; i < 1000; i++)
	{
		theta = 2.0*M_PI*i/1000.0;
		E = A_t*x_t + A_c*(x_c*cos(theta)-y_c*sin(theta));
		F = A_t*y_t + A_c*(x_c*sin(theta)+y_c*cos(theta));
		P = bessel_I0(sqrt(E*E + F*F)/(sigma1*sigma1));
		a[2][i] = P;
	}
	x_t = A_t = 10.0;
	x_c = -(A_c = 10.0);
	for(i = 0; i < 1000; i++)
	{
		theta = 2.0*M_PI*i/1000.0;
		E = A_t*x_t + A_c*(x_c*cos(theta)-y_c*sin(theta));
		F = A_t*y_t + A_c*(x_c*sin(theta)+y_c*cos(theta));
		P = bessel_I0(sqrt(E*E + F*F)/(sigma1*sigma1));
		a[3][i] = P;
	}
	x_t = A_t = 0.25;
	for(i = 0; i < 1000; i++)
	{
		theta = 2.0*M_PI*i/1000.0;
		E = A_t*x_t + A_c*(x_c*cos(theta)-y_c*sin(theta));
		F = A_t*y_t + A_c*(x_c*sin(theta)+y_c*cos(theta));
		P = bessel_I0(sqrt(E*E + F*F)/(sigma1*sigma1));
		a[4][i] = P;
	}

	scaleVector(a[1], 1000.0/(2.0*M_PI*Vectorsum(a[1])));
	scaleVector(a[2], 1000.0/(2.0*M_PI*Vectorsum(a[2])));
	scaleVector(a[3], 1000.0/(2.0*M_PI*Vectorsum(a[3])));
	scaleVector(a[4], 1000.0/(2.0*M_PI*Vectorsum(a[4])));

	for(i = 1; i < 5; i++)
	{
		goal = 0.68268949*Vectorsum(a[i])/2.0;
		goal -= 0.5*a[i][500];
		for(j = 501; j < 1000; j++)
		{
			goal -= a[i][j];
			if(goal < 0.0) break;
		}
		j -= 500;
		printf("1sigma confidence half width = %f deg\n",
				180.0*j/500.0);
	}

	scaleVector(a[0], 180.0/M_PI);

	VecArraytofile(a, "inbeam.out", 0);

	deleteVecArrayandVectors(a);

	return 0;
}
