#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/randdist.h>
#include <wfblib/image.h>
#include <wfblib/image-vector.h>
#include <wfblib/vector-fftw.h>

#define Nx      400
#define Ny      256

int main()
{
	Matrix M, M2;
	Vector V, V2;
	Image I;
	int j, i;

	M = newpaddedMatrix(Ny, Nx, 2);
	zeroMatrix(M);
	M[0][10] = 1.0;
	MatrixRFFT(M, FFTW_BACKWARD);

	for(j = 0; j < MatrixSize1(M); j++) for(i = 0; i < MatrixSize2(M); i++)
		M[j][i] += 100.0*rand_gauss();

	M2 = dupMatrix(M);
	MatrixRFFT(M, FFTW_FORWARD);
	MatrixRFFTrows(M2, FFTW_FORWARD);
	V = newVector(Nx/2);
	V2 = newVector(Nx/2);
	zeroVector(V);
	zeroVector(V2);
	for(i = 0; i < Nx/2; i++)
	{
		V[i] = sqrt(M[0][2*i]*M[0][2*i] + M[0][2*i+1]*M[0][2*i+1]);
		for(j = 0; j < Ny; j++)
			V2[i]+=sqrt(M2[j][i]*M2[j][i]+M2[j][Nx-i]*M2[j][Nx-i]);
	}
	saveVectorasascii(V, "V");
	saveVectorasascii(V2, "V2");

	I = newImagefromMatrix(M);
	saveImage(I, "ifft2.png");
	deleteImage(I);

	I = newImagefromMatrix(M2);
	saveImage(I, "ifft3.png");
	deleteImage(I);

	deleteMatrix(M);
	deleteMatrix(M2);
	deleteVector(V);
	deleteVector(V2);
	
	return 0;
}
