#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/randdist.h>
#include <wfblib/image.h>
#include <wfblib/image-vector.h>
#include <wfblib/vector-fftw.h>

#define Nx      400
#define Ny      256

int main()
{
	Matrix M;
	Vector V, V2;
	Image I;
	int i, m, n;
	double x, y, z;

	M = newpaddedMatrix(Ny, Nx, 2);

	V = newVector(24);
	
	zeroVector(V);

	V[6] = 1.0;

	V2 = VectorRFFT(V, FFTW_COMPLEX_TO_REAL);
	

	for(i = 0; i < 24; i++) printf("%f\n", V2[i]);

	zeroMatrix(M);

	for(i = 0; i < 300; i++)
	{
		rand_shell(&x, &y, &z);
		m = (int)(Nx+34*fabs(x)*Nx/Ny) % Nx;
		n = (int)(Ny+17*y) % Ny;
		M[n][m] += z;
	}

	MatrixRFFT(M, FFTW_BACKWARD);

	I = newImagefromMatrix(M);

	saveImageaspgm(I, "ifft.pgm");

	deleteImage(I);
	deleteMatrix(M);
	
	return 0;
}
