#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/vector-fftw.h>
#include <wfblib/image.h>
#include <wfblib/image-vector.h>

#define MSize 400

int main()
{
	Matrix M, R;
	Image I;
	int i, j;
	double theta;

	M = newMatrix(MSize, 2*MSize);
	zeroMatrix(M);
	
	/*
	complexgrid(M, 10.5, 5.5, 1.0, 0.0);
	complexgrid(M, -10.5, -5.5, 1.0, 0.0);
	*/
	for(i = 0; i < 128; i++)
	{
		theta = 2.0*M_PI*(float)i/128.0;
		Matrixcomplexgrid(M, 40.0*cos(theta), 40.0*sin(theta), 
			1.0, 0.0, 20);
	}

	I = newImagefromMatrix(M);
	saveImageaspgm(I, "im.pgm");
	deleteImage(I);
	
	MatrixFFT(M, FFTW_FORWARD);

	R = newMatrix(MSize, MSize);
	for(j = 0; j < MSize; j++) for(i = 0; i < MSize; i++)
		R[j][i] = M[j][2*i];

	rollMatrixinplace(R, MSize/2, MSize/2);

	I = newImagefromMatrix(R);
	saveImageaspgm(I, "im2.pgm");
	deleteImage(I);

	deleteMatrix(R);
	deleteMatrix(M);

	return 0;
}
