#include <stdio.h>
#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/lapack.h>

//void nonsymeigensolve(const Matrix V, Vector REvals,
  //      Vector IMvals, Matrix vecs);

int main()
{
	Vector rv, iv;
	Matrix  M, A, Ai, MA, AiMA, AAi;
	int L = 5;
	int i;
	Vector work;
	
	M = newMatrix(L, L);
	A = newMatrix(L, L);
	rv = newVector(L);
	iv = newVector(L);

	zeroMatrix(M);
	for(i = 0; i < L; i++) M[i][i] = 1+i;
	M[2][2] = 4;
	M[2][3] = 2;
	M[3][2] = 3;
	printf("M = "); printMatrix(M);

	powMatrix(M, 2.0);

	nonsymeigensolve(M, rv, iv, A);

	MA = Matrixmultiply(M, A);

	printf("M = "); printMatrix(M);
	printf("A = "); printMatrix(A);
	printf("rv= "); printVector(rv);
	printf("iv= "); printVector(iv);
	printf("MA = "); printMatrix(MA);
	
	work = newVector(L);

	zeroVector(work);

	Ai = dupMatrix(A);
	MatrixLUinvert(Ai);
	printf("i = %d\n", i);

	printf("Ai = "); printMatrix(Ai);

	AAi = Matrixmultiply(A, Ai);
	printf("AAi = "); printMatrix(AAi);

	AiMA = Matrixmultiply(Ai, MA);
	printf("AiMA = "); printMatrix(AiMA);

	return 0;
}
