#include <math.h>
#include <wfblib/vector.h>
#include <wfblib/randdist.h>
#include <wfblib/image.h>
#include <wfblib/image-vector.h>
#include <wfblib/vector-fftw.h>

#define Nx      400
#define Ny      256

int main()
{
	Matrix M, A, B, C, D, E, F, clean, restored;
	Image I;
	int i, j;
	double r;


	M = newMatrix(200, 200);
	zeroMatrix(M);
	A = refsubMatrix(M, 0, 0, 99, 99);
	B = refsubMatrix(M, 100, 0, 199, 99);
	C = refsubMatrix(M, 0, 100, 99, 199);
	D = refsubMatrix(M, 100, 100, 199, 199);
	
	for(j = -7; j <= 7; j++) for(i = -7; i <= 7; i++)
	{
		r = sqrt(i*i + j*j);
		if(r < 7.0) B[50+j][50+i] = A[50+j][50+i] = 7.0 - r;
		if(r < 7.0) A[70+j][70+i] = (49.0 - r*r)/7.0;
	}

	rollMatrixinplace(A, 90, 90);

	copytoMatrix(C, A);
	copytoMatrix(D, A);
	Matrixconvolve(C, A);
	Matrixconvolve(D, B);

	E = Matrixcrosscorrelate(A, A);
	copytoMatrix(D, E);

	rollMatrixinplace(C, 50, 50);
	rollMatrixinplace(D, 50, 50);

	scaleMatrix(A, 1.0/Matrixmax(A));
	scaleMatrix(B, 1.0/Matrixmax(B));
	scaleMatrix(C, 1.0/Matrixmax(C));
	scaleMatrix(D, 1.0/Matrixmax(D));

	deleteMatrix(A);
	deleteMatrix(B);
	deleteMatrix(C);
	deleteMatrix(D);
	

	I = newImagefromMatrix(M);

	saveImageaspgm(I, "correlate.pgm");

	deleteImage(I);
	deleteMatrix(M);

	A = newMatrix(100, 100);
	B = newMatrix(100, 100);
	clean = newMatrix(100, 100);
	restored = newMatrix(100, 100);
	M = newMatrix(300, 1000);

	zeroMatrix(A);
	zeroMatrix(B);
	zeroMatrix(clean);
	zeroMatrix(restored);
	zeroMatrix(M);

	for(j = -7; j <= 7; j++) for(i = -7; i <= 7; i++)
	{
		r = sqrt(i*i + j*j);
		if(r < 7.0) A[50+j][50+i] = 7.0 - r;
	}

	B[50][50] = 1.0;
	B[52][50] = 1.5;
	B[54][48] = 2.0;
	B[60][60] = 1.0;
	B[30][30] = 1.0;

	Matrixconvolve(B, A);
	rollMatrixinplace(B, 50, 50);
	
	for(i = 0; i < 10; i++)
	{
		C = refsubMatrix(M, 0, 100*i, 99, 100*i+99);
		D = refsubMatrix(M, 100, 100*i, 199, 100*i+99);
		E = refsubMatrix(M, 200, 100*i, 299, 100*i+99);
		
		copytoMatrix(C, B);
		printf("C Max = %f\n", Matrixmax(C));
		F = Matrixcrosscorrelate(B, A);
		printf("F Max = %f\n", Matrixmax(F));
		copytoMatrix(D, F);

		scaleMatrix(C, 1.0/Matrixmax(C));
		scaleMatrix(D, 1.0/Matrixmax(D));
		deleteMatrix(C);
		deleteMatrix(D);
	}

	I = newImagefromMatrix(M);

	saveImageaspgm(I, "clean.pgm");

	deleteImage(I);
	deleteMatrix(M);
	
	return 0;
}
