#include <wfblib/vector.h>
#include <wfblib/vector-fftw.h>
#include <wfblib/randdist.h>

#define N 2048
#define H 256

int main()
{
	Vector V, W, S;
	int i, j, e;

	
	V = newVector(N);
	S = newVector(N/2+1);
	zeroVector(S);

	for(e = 0; e < 10000; e++)
	{
		for(i = 0; i < N; i+=H) 
			if(rand_one() > 0.5) 
				for(j = 0; j < H; j++) V[i+j] = 0.5; 
			else for(j = 0; j < H; j++) V[i+j] = -0.5;

		for(i = 0; i < N; i++) V[i] = rand_one();

		W = VectorFFT(V, FFTW_FORWARD);

		S[0] += W[0]*W[0];

		for(i = 1; i < N/2; i++)
			S[i] += W[i]*W[i] + W[N-i]*W[N-i];

		S[N/2] += W[N/2]*W[N/2];

	}

	saveVectorasascii(W, "bf");
	saveVectorasascii(S, "bf2");
		
	return 0;
}
