#include <math.h>
#include <stdio.h>
#include <wfblib/astrometry.h>

int main()
{
	double ra;
	double dec;
	double mua;
	double mud;
	double eps=1e-6;
	double l1, b1, l2, b2;

	ra = 1.869682778*M_PI/12.0;
	dec = -16.63145*M_PI/180.0;

	mua = 3.1;
	mud = -27.2;

	coordconv(ra, dec, &l1, &b1, EQU_TO_GAL);
	coordconv(ra+mua*eps/cos(dec), dec+mud*eps, &l2, &b2, EQU_TO_GAL);

	printf("ra = %f dec = %f l = %f,%f b = %f,%f\n", ra, dec, l1, l2, 
		b1, b2);

	printf("mul = %f, mub = %f\n", (l2-l1)*cos(b1)/eps, (b2-b1)/eps);

	return 0;
}
