/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __catalog_h__
#define __catalog_h__

#include <stdio.h>
#include <gtk/gtk.h>
#include "iconlist.h"
#include "viewer.h"
#include "object.h"
#include "catinfo.h"

#define SEARCHABLE      1
#define HASDATA         2
#define LOADDATA        4

struct catalog
{
	double epoch;
	int numobjects;
	char *name;
	char type[20];
	char filename[130];
	char *description;
	struct catinfo *info;
	struct classheader *ch;	/* == 0 if contains multiple obj types*/

	char lut_name[20];
	struct object *objects;
	int numextensions;	/* Set to the largest of objects in cat */
	float *extension;
	int searchable;

	char *lookupfile;
	int catalogindexoffset;	/* <=0 means use column -catalogindexoffset */

	int catmask;
	int ignore;
};

struct catalog *nextcatalog(struct catalog *cat, int flags);

struct catalog *newcatalog();

void addcatalog(struct catalog *cat);

int catalogloaddata(struct catalog *cat);

int catalogunloaddata(struct catalog *cat);

struct catalog *loadcatalog(char *str);

int loadallcatalogs(const char *filename);

void destroycatalog(struct catalog *cat);

void destroyallcatalogs(GList *cats);

void catalog_render_pixmap(struct catalog *cat, struct iconlist *il, struct viewer *v);

void render_pixmap(struct iconlist *il,
	struct viewer *v);

void render_ps(struct catalog *cat, struct viewer *v, 
	FILE *out, double *scale);

int search(struct catalog *cat, int x, int y, struct viewer *v, double *dist);

void selectall(struct catalog *cat, struct viewer *v);

void unselectall(struct catalog *cat, struct viewer *v);

void selectrange(struct catalog *cat, struct viewer *v, int type, 
	int mine, int maxe);

void unselectrange(struct catalog *cat, struct viewer *v, int type, 
	int mine, int maxe);

double catclosest(struct catalog *cat, struct viewer *v,
	long X, long Y, long Z, long *n);

double catdist(struct catalog *cat1, int index1, 
	       struct catalog *cat2, int index2);
	

#endif
