/*****************************************************************
 * 
 * proc_inl_fn_rec_fork.c : 
 *
 *
 *	 - Executes a set of malloc,loop,free as inline code,
 *	   in repeated function calls, in recursion, 
 *	   and by forking processes.
 *
 *	 - Command line : 
 *	         
 *	         proc_inl_fn_rec_fork <ntimes> 
 *
 *	         ntimes : number of times to execute the test loop 
 *	         		(0==default=100)
 *
 *
 *    inline, fn call, recursion, forking.
 *
 * 
 * ***************************************************************/

#include "perftest.h"

int proc_inl_fn_rec(int ntimes);
int testfn(int i);
int testrec(int i);

int size=64;

int main(int argc,char **argv)
{
	int ntimes=0;
	
	/* read ntimes from argv */

	if(argc<2)
	{
		printf("\n Usage :   proc_inl_fn_rec_fork <ntimes> \n\n\tntimes : Number of times to execute the test loop ( 0 == default = 100 )\n\n ");
		return(-1);
	}

	ntimes = atoi(argv[1]);

	if(ntimes<=0)ntimes=100;

	if(proc_inl_fn_rec(ntimes)<0)perror("Error in proc_inl_fn_rec\n");
	
	return(0);	
}


int proc_inl_fn_rec(int ntimes)
{
	int i,j,sum=0,tsum=0,err=0,ferr=0,stat=0;
	int *data=NULL;
	double inlinetime=0,fntime=0,rectime=0,forktime=0;
	int fildes[2];
		
	size=10;
	stat=0;


	/* Inline */
	
	GetTime(1);
	for(i=0;i<ntimes;i++)
	{
		sum=0;
		data = (int*)malloc(sizeof(int)*size);
		for(j=0;j<size;j++) data[j] = j;
		for(j=0;j<size;j++) 
		{
			data[j] = data[j] + i+j;
			sum += data[j];
		}
		free(data);
		tsum += sum;
	}
	inlinetime=GetTime(2);
	
	//printf("inline tsum= %d time= %6.6lf   ",tsum,inlinetime);

	/* Function calls */
	
	tsum=0;sum=0;

	GetTime(1);
	for(i=0;i<ntimes;i++)
	{
		tsum += testfn(i);
	}
	fntime=GetTime(2);
	
	//printf("fn tsum= %d time= %6.6lf   ",tsum,fntime);

	/* Recursive Calls */
	tsum=0;sum=0;
	
	GetTime(1);
	tsum = testrec(ntimes-1);
	rectime=GetTime(2);
	
	//printf("rec tsum= %d time= %6.6lf   ",tsum,rectime);

	//fflush(stdout);

	/* Forking ! */
	
	err = pipe(fildes);	
	tsum=0;sum=0;
	
	GetTime(1);
	for(i=0;i<ntimes;i++)
	{
		ferr=fork();
		if(ferr<0) printf("err = %d  \n",ferr);
		if(ferr==0)
		{
			sum=0;
			data = (int*)malloc(sizeof(int)*size);
			for(j=0;j<size;j++) data[j] = j;
			for(j=0;j<size;j++) 
			{
				data[j] = data[j] + i+j;
				sum += data[j];
			}
			free(data);
			write(fildes[1],&sum,sizeof(int));
			exit(0);

		}
		else
		{
			wait(&stat);
			read(fildes[0],&sum,sizeof(int));
			tsum += sum;
		}
	}
	forktime=GetTime(2);
	
	//printf("forking tsum= %d time= %6.6lf\n",tsum,forktime);
	
	
	printf("inline= %6.6lf   fn= %6.6lf   rec= %6.6lf   fork= %6.6lf\n",inlinetime, fntime, rectime, forktime);
	
	return(0);
	
}

int testfn(int i)
{
	int sum=0,j;
	int *data=NULL;
	
	sum=0;
	data = (int*)malloc(sizeof(int)*size);
	for(j=0;j<size;j++) data[j] = j;
	for(j=0;j<size;j++) 
	{
		data[j] = data[j] + i+j;
		sum += data[j];
	}
	free(data);
	return(sum);
}

int testrec(int i)
{
	int *data=NULL;
	int j,tsum=0,sum=0;

	if(i>0) tsum = testrec(i-1);

	data = (int*)malloc(sizeof(int)*size);
	for(j=0;j<size;j++) data[j] = j;
	sum=0;
	for(j=0;j<size;j++) 
	{
		data[j] = data[j] + i+j;
		sum += data[j];
	}
	free(data);
	tsum += sum;
	return(tsum);

}


