/*****************************************************************
 * 
 * 	mem_single_multi_loop.c 
 *	
 *	 - allocate memory - different sizes
 *	 		 loop over it in single large loops
 *	                 loop over several pieces of it
 *
 *	 - hope to find an optimum (piece)chunk size
 *	   - least time for N=1000 iterations
 *
 *	 - Command line : 
 *	         
 *	         mem_single_multi_loop <memsize> <kbsize>
 *
 *	         memsize : mem alloc size in Kilobytes (0 == default = 2048)
 *	         
 *	         kbsize : piece size in Kilobytes (0 == default = 32)
 *
 * 
 * ***************************************************************/

#include "perftest.h"

int mem_single_multi_loop(int memsize,int kbsize);

int main(int argc,char **argv)
{
	int kbsize=0,memsize=0;

	/* read kbsize and ntimes from argv */

	if(argc<3)
	{
		printf("\n Usage :   mem_single_multi_loop <memsize> <kbsize> \n\n\t  memsize : mem alloc size in Kilobytes (0 == default = 2048)\n\t  kbsize : piece size in Kilobytes (0 == default = 32)\n\n ");
		return(-1);
	}

	memsize = atoi(argv[1]);
	kbsize = atoi(argv[2]);

	if(kbsize<=0)kbsize=32;
	if(memsize<=0)memsize=2048;

	if(mem_single_multi_loop(memsize,kbsize)<0)perror("Error in mem_single_multi_loop\n");
	
	return(0);	
}


int mem_single_multi_loop(int memsize,int kbsize)
{

	int *data = NULL;
	int i,j,p,N,temp=0,M,tp=0,si=0;
	double multiloop=0;
	
	N = 1000;
	M = memsize; // size in KB 
	si=kbsize*1024/sizeof(int);

	data = (int *)malloc(M*1024);
	
	/* sequential access - write */
	
	/* multiple loops */
	temp = (int) (M/kbsize);
	GetTime(1);
	for(p=0;p<temp;p++)
	{
		tp = p*si;
		for(i=0;i<N;i++)
			for(j=0;j<si;j++)
				data[tp+j] = j+i ;
	}	
	multiloop = GetTime(2);
	
	free(data);

	printf("mem= %d   piece= %d    np= %d    multi= %6.6lf \n",memsize,kbsize,temp,multiloop);


	return(0);
	
}

