/*****************************************************************
 * 
 * 	mem_cache_ram_swap.c 
 *	
 *	 - allocate mem, read from it, write to it and read it again. 
 *	   For each, loop over it <ntimes> times
 *
 *	 - Command line : 
 *	         
 *	         mem_cache_ram_swap <kbsize> <ntimes>
 *
 *	         kbsize : chunk size in Kilobytes (0 == default = 1024)
 *
 *	         ntimes : number of iterations (0 == default = 10)
 *
 * 
 * ***************************************************************/

#include "perftest.h"


int mem_cache_ram_swap(int kbsize,int ntimes);

int main(int argc,char **argv)
{
	int kbsize=0,ntimes=0;

	/* read kbsize and ntimes from argv */

	if(argc<3)
	{
		printf("\n Usage :   mem_cache_ram_swap <kbsize> <ntimes> \n\n  kbsize : chunk size in Kilobytes (0 == default = 1024)\n  ntimes : number of iterations (0 == default = 10)\n\n ");
		return(-1);
	}

	kbsize = atoi(argv[1]);
	ntimes = atoi(argv[2]);

	if(kbsize<=0)kbsize=1024;
	if(ntimes<=0)ntimes=10;

	if(mem_cache_ram_swap(kbsize,ntimes)<0)perror("Error in mem_cache_ram_swap\n");
	
	return(0);	
}


int mem_cache_ram_swap(int kbsize,int ntimes)
{

	int *data = NULL;
	int i,j,N,sum=0,si=0;
	double writetime1=0,readtime1=0,readtime2=0;
	
	N = ntimes;
	//N=1000;
	si=kbsize*1024/sizeof(int);
	
	data = (int *)malloc(kbsize*1024);
#if 0	
	/* sequential access - read */
	GetTime(1);
	for(i=0;i<N;i++)
		for(j=0;j<kbsize*1024/si;j++)
			sum = data[j];
		
	readtime1 = GetTime(2);
#endif	
	
	/* sequential access - write */
	GetTime(1);
	for(i=0;i<N;i++)
		for(j=0;j<si;j++)
			data[j] = j+i ;
		
	writetime1 = GetTime(2);
	
	
	/* sequential access - read */
	GetTime(1);
	for(i=0;i<N;i++)
		for(j=0;j<si;j++)
			sum = data[j];
		
	readtime2 = GetTime(2);

	/* sequential access - write */
	GetTime(1);
	for(i=0;i<N;i++)
		for(j=0;j<si;j++)
			data[j] = j+i ;
		
	readtime1 = GetTime(2);
	
	
	
	//for(j=0;j<kbsize*1024/si;j++) sum += data[j];
	free(data);

	//printf("junk= %d    kbsize= %d    niter= %d    read1= %5.4lf     write= %5.4lf     read2= %5.4lf\n",sum,kbsize,ntimes,readtime1,writetime1,readtime2);
	printf("junk= %d    kbsize= %d    niter= %d    write1= %5.4lf     read= %5.4lf     write2= %5.4lf\n",sum,kbsize,ntimes,writetime1,readtime2,readtime1);
	
	
	return(0);
	
}





