/*****************************************************************
 * 
 * disk_seq_ran_read.c : fixed size data file - 512MB
 *
 * 	read it - sequentially and randomly...
 *
 *	 - using 'read','write', 'open', 'close'
 *
 * 	 - do sequential and random reads with different block sizes
 * 	   starting from 1KB ( smaller than page size ) and go up and 
 * 	   see where the page read-ahead limit is. sample at
 * 	   1,2,3,4,5,.....64Kb
 *
 * 	 - also do the usual seq vs ran read time in chunks of
 * 	   1,2,4,8,...KB. Try to flush the file cache (?) by writing
 * 	   another file into disk.
 *
 *	 - Command line : 
 *	         
 *	         disk_seq_ran_read <kbsize> 
 *
 *	         kbsize : chunk size in KB (0 == default = 1Kb)
 *
 * 
 * ***************************************************************/

#include "perftest.h"

int disk_seq_ran_read(int kbsize);

int main(int argc,char **argv)
{
	int kbsize=0;

	/* read kbsize from argv */

	if(argc<2)
	{
		printf("\n Usage :   disk_seq_ran_read <kbsize> \n\n kbsize : chunk size in KB (0 == default = 1KB)\n\n ");
		return(-1);
	}

	kbsize = atoi(argv[1]);

	if(kbsize <=0) kbsize = 1;

	if(disk_seq_ran_read(kbsize)<0)perror("Error in disk_seq_ran_read\n");
	
	return(0);	
}


int disk_seq_ran_read(int kbsize)
{
	int fd=0;
	int i,nbuff=0,n=0,off=0,nb=0;
	char *data=NULL;
	double seqtime=0,rantime=0,rant=0;

	
	//n = 512 * 1024; // size in KB of target file
	n = NN; // size in KB of target file
	nb = n/kbsize;

	nbuff = 1000;
	
	data = (char*)malloc(kbsize*1024);

#if 0
	/* dirty and write the file to disk  - try to make this the size
	 * of the file cache - once that is found (IFF) */
	for(i=0;i<kbsize*1024;i++) data[i]= i % 250;
	fd = open("scratch",O_RDWR|O_SYNC);
	for(i=0;i<nbuff;i++)
		write(fd,data,kbsize*1024);
	close(fd);	
#endif
	/* read the file = random */
	GetTime(1);
	for(i=0;i<nbuff;i++)
	{
		off = (int)((double)abs(rand())/RAND_MAX*(nb-1)*kbsize*1024);
	}
	rant = GetTime(2);

	/* random seeks are NOT to page boundaries.. */
	
	fd = open("scratchfile",O_RDWR|O_SYNC);
	GetTime(1);
	for(i=0;i<nbuff;i++)
	{
		off = (int)((double)abs(rand())/RAND_MAX*(nb-1)*kbsize*1024);
		lseek(fd,off,SEEK_SET);
		read(fd,data,kbsize*1024);
	}
	rantime = GetTime(2) - rant;
	close(fd);

	/* read the file - sequential */
	fd = open("scratchfile",O_RDWR|O_SYNC);
	off=0;
	GetTime(1);
	for(i=0;i<nbuff;i++)
	{
		lseek(fd,0,SEEK_CUR);
		read(fd,data,kbsize*1024);
	}
	seqtime = GetTime(2);
	close(fd);

	free(data);
	
	printf("bufsize= %d KB   nbuff= %d   seq= %10.6lf   ran= %10.6lf \n",kbsize,nbuff,seqtime,rantime);


	return(0);
	
}

