/*****************************************************************
 * 
 * disk_rwr_read.c : fixed size data file - 512MB
 *
 * 	read it, write it out with diff values, read it again
 *
 *	Synchronous read/write in chunks of size <kbsize> 
 *	 
 *	 - using 'read','write', 'open', 'close'
 *
 * 	 - should see that..... ????
 *
 *	 - Command line : 
 *	         
 *	         disk_rwr_read <kbsize> <buf>
 *
 *	         kbsize : chunk size in Kilobytes (0 == default = 1)
 *
 *	         buf : synchronous vs asynchronous i/o (0 == default = (1))
 *                     (1) Synchronous I/O
 *                     (2) Asynchronous I/O
 *
 * 
 * ***************************************************************/

#include "perftest.h"

int disk_rwr_read(int kbsize,int buf);

int main(int argc,char **argv)
{
	int kbsize=0,buf=0;

	/* read kbsize and buf from argv */

	if(argc<3)
	{
		printf("\n Usage :   disk_rwr_read <kbsize> <buf> \n\n  kbsize : chunk size in Kilobytes (0 == default = 1)\n  buf : synchonous/asynchronous i/o (0 == default = (1))\n\t(1) Synchronous I/O\n\t(2) Asynchronous I/O\n\n ");
		return(-1);
	}

	kbsize = atoi(argv[1]);
	buf = atoi(argv[2]);

	if(kbsize<=0)kbsize=1;
	if(buf != 1 && buf != 2)buf=1;

	if(disk_rwr_read(kbsize,buf)<0)perror("Error in disk_rwr_read\n");
	
	return(0);	
}


int disk_rwr_read(int kbsize,int buf)
{
	int fd=0;
	int i,nbuff=0,n=0;
	char *data=NULL;
	double writetime=0,readtime1=0,readtime2=0;

	
	//n = 512 * 1024; // size in KB of target file
	n = NN; // size in KB of target file
	nbuff = n/kbsize;
	
	data = (char*)malloc(kbsize*1024);

	/* read the file */
	if(buf == 1)fd = open("scratchfile",O_RDWR|O_SYNC);
	else fd = open("scratchfile",O_RDWR);
	GetTime(1);
	for(i=0;i<nbuff;i++)
		read(fd,data,kbsize*1024);
	readtime1 = GetTime(2);
	close(fd);
	
	for(i=0;i<kbsize*1024;i++) data[i]= i % 250;

	/* write the file */
	if(buf == 1)fd = open("scratchfile",O_RDWR|O_SYNC);
	else fd = open("scratchfile",O_RDWR);
	GetTime(1);
	for(i=0;i<nbuff;i++)
		write(fd,data,kbsize*1024);
	writetime = GetTime(2);
	close(fd);

	/* read the file */
	if(buf == 1)fd = open("scratchfile",O_RDWR|O_SYNC);
	else fd = open("scratchfile",O_RDWR);
	GetTime(1);
	for(i=0;i<nbuff;i++)
		read(fd,data,kbsize*1024);
	readtime2 = GetTime(2);
	close(fd);
	
	free(data);
	
	printf("bufsize= %d KB   nbuff= %d   r= %10.6lf   w= %10.6lf  r= %10.6lf \n",kbsize,nbuff,readtime1,writetime,readtime2);


	return(0);
	
}

