/*****************************************************************
 * 
 * disk_rwr_mmap.c : fixed size data file - 512MB
 *
 * 	read it, write it out with diff values, read it again
 *
 *	Synchronous read/write in chunks of size <kbsize> 
 *	 
 *	 - using 'open','close','mmap','msync', 'munmap'
 *
 * 	 - should see that..... ????
 *
 *	 - Command line : 
 *	         
 *	         disk_rwr_mmap <kbsize> 
 *
 *	         kbsize : chunk size in Kilobytes 
 *	                  MUST be a multiple of 4 (page size=4Kb)
 *	                  (0 == default = 256)
 *
 * 
 * ***************************************************************/

#include "perftest.h"

int disk_rwr_mmap(int kbsize);

int main(int argc,char **argv)
{
	int kbsize=0;

	/* read kbsize from argv */

	if(argc<2)
	{
		printf("Usage :   disk_rwr_asynch <kbsize>  \n\n  kbsize : chunk size in Kilobytes \n	MUST be a multiple of 4 (page size = 4Kb\n	(0 == default = 256)\n\n ");
		return(-1);
	}

	kbsize = atoi(argv[1]);

	if(kbsize<=0)kbsize=256;
	if(kbsize%4 != 0){printf("<kbsize> must be a multiple of 4\n"); return(-1);}

	if(disk_rwr_mmap(kbsize)<0)perror("Error in disk_rwr_mmap\n");
	
	return(0);	
}


int disk_rwr_mmap(int kbsize)
{
	int fd=0,pgsize=0,err=0;
	int i,j,nbuff=0,n=0;
	void *startaddress=0;
	char *data=NULL;
	double writetime=0,readtime1=0,readtime2=0;


	pgsize = getpagesize();
	
	//n = 512 * 1024; // size in KB of target file
	n = NN; // size in KB of target file
	nbuff = n/kbsize;
	
	data = (char*)malloc(kbsize*1024);

/* HOW ON EARTH TO TOUCH THE MMAP'D MEMORY WITHOUT LOOPING OVER IT ! */
	
	/* read the file */
	fd = open("scratchfile",O_RDWR);
	GetTime(1);
	for(i=0;i<nbuff;i++)
	{
		startaddress = mmap(0,kbsize*1024,PROT_READ|PROT_WRITE,MAP_SHARED,fd,0);
/* ?? */	for(j=0;j<kbsize*1024;j++)data[j]= *((char*)(startaddress)+j);
		err = munmap(startaddress,kbsize*1024);
		lseek(fd,kbsize*1024,SEEK_CUR);
	}
		//read(fd,data,kbsize*1024);
	readtime1 = GetTime(2);
	close(fd);
	
#if 1
	for(i=0;i<kbsize*1024;i++) data[i]= i % 250;

	/* write the file */
	fd = open("scratchfile",O_RDWR);
	GetTime(1);
	for(i=0;i<nbuff;i++)
	{
		startaddress = mmap(0,kbsize*1024,PROT_READ|PROT_WRITE,MAP_SHARED,fd,0);
		for(j=0;j<kbsize*1024;j++)  *((char*)startaddress + j) = data[j];
		err = munmap(startaddress,kbsize*1024);
		lseek(fd,kbsize*1024,SEEK_CUR);
	}
	//	write(fd,data,kbsize*1024);
	writetime = GetTime(2);
	close(fd);

	/* read the file */
	fd = open("scratchfile",O_RDWR);
	GetTime(1);
	for(i=0;i<nbuff;i++)
	{
		startaddress = mmap(0,kbsize*1024,PROT_READ|PROT_WRITE,MAP_SHARED,fd,0);
/* ?? */	for(j=0;j<kbsize*1024;j++) data[j]= *((char*)startaddress + j);
		err = munmap(startaddress,kbsize*1024);
		lseek(fd,kbsize*1024,SEEK_CUR);
	}
	//	read(fd,data,kbsize*1024);
	readtime2 = GetTime(2);
	close(fd);
#endif	
	free(data);
	
	printf("bufsize= %d KB   nbuff= %d   r= %10.6lf   w= %10.6lf  r= %10.6lf \n",kbsize,nbuff,readtime1,writetime,readtime2);


	return(0);
	
}

