/*****************************************************************
 * 
 * disk_rwr_fread.c : fixed size data file - 512MB
 *
 * 	read it, write it out with diff values, read it again
 *
 *	Asynchronous read/write in chunks of size <kbsize> 
 *	 
 *	 - using 'fread','fwrite', 'fopen', 'fclose'
 *
 *	 - with and/or without stream buffering (setvbuf)
 *
 *	 - Should see the effect that the initial read gets data
 *	   from the disk, and then that the writes do not actually
 *	   Write to the disk - and when you start reading again, 
 *	   everything's still in the memory - but when you start
 *	   reading beyond the size of the RAM, THEN the read times 
 *	   slow down a lot because it's actually writing to disk
 *	   first, trying to clean up the pages !
 *
 *	 - Command line : 
 *	         
 *	         disk_rwr_fread <kbsize> <buf>
 *
 *	         kbsize : chunk size in Kilobytes (0 == default = 1)
 *	         buf : file stream i/o buffering (0 == default = (1))  
 *	               (1) no stream buffering 
 *	               (2) default i/o stream buffering - 8KB
 *
 * 
 * ***************************************************************/

#include "perftest.h"

int disk_rwr_fread(int kbsize,int buf);

int main(int argc,char **argv)
{
	int kbsize=0,buf=0;

	/* read kbsize and buf from argv */

	if(argc<3)
	{
		printf("\n Usage :   disk_rwr_fread <kbsize> <buf> \n\n  kbsize : chunk size in Kilobytes (0 == default = 1)\n  buf : file stream i/o buffering (0 == default = (1))\n\t(1) no stream buffering \n\t(2) default stream buffering - 8KB\n\n ");
		return(-1);
	}

	kbsize = atoi(argv[1]);
	buf = atoi(argv[2]);

	if(kbsize<=0)kbsize=1;
	if(buf != 1 && buf != 2)buf=1;

	if(disk_rwr_fread(kbsize,buf)<0)perror("Error in disk_rwr_fread\n");
	
	return(0);	
}


int disk_rwr_fread(int kbsize,int buf)
{
	FILE *fp=NULL;
	int i,nbuff=0,n=0;
	char *data=NULL;
	double writetime=0,readtime1=0,readtime2=0;

	
	//n = 512 * 1024; // size in KB of target file
	n = NN; // size in KB of target file
	nbuff = n/kbsize;
	
	data = (char*)malloc(kbsize*1024);

	/* read the file */
	//fp = fopen("tempfile512","r");
	fp = fopen("scratchfile","r");
 	if(buf == 1) setvbuf(fp,NULL,_IONBF,0);
	GetTime(1);
	for(i=0;i<nbuff;i++)
		fread(data,sizeof(char),kbsize*1024,fp);
	readtime1 = GetTime(2);
	fclose(fp);
	
	for(i=0;i<kbsize*1024;i++) data[i]= i % 250;

	/* write the file */
	//fp = fopen("tempfile512","w");
	fp = fopen("scratchfile","r");
 	if(buf == 1)setvbuf(fp,NULL,_IONBF,0);
	GetTime(1);
	for(i=0;i<nbuff;i++)
		fwrite(data,sizeof(char),kbsize*1024,fp);
	writetime = GetTime(2);
	fclose(fp);

	/* read the file */
	//fp = fopen("tempfile512","r");
	fp = fopen("scratchfile","r");
 	if(buf == 1)setvbuf(fp,NULL,_IONBF,0);
	GetTime(1);
	for(i=0;i<nbuff;i++)
		fread(data,sizeof(char),kbsize*1024,fp);
	readtime2 = GetTime(2);
	fclose(fp);
	
	free(data);

	printf("bufsize= %d KB   nbuff= %d   r= %10.6lf   w= %10.6lf  r= %10.6lf \n",kbsize,nbuff,readtime1,writetime,readtime2);


	return(0);
	
}

