/*****************************************************************
 * 
 * disk_read_vs_mmap.c : fixed size data file 
 * 
 * 	read it - sequentially in chunks
 * 	
 * 	read each chunk, loop over it to write new data in and
 * 	write it to the file synchronously.  Time the read,loop 
 * 	and write operations for 'read/write' and 'mmap/munmap'
 *
 *	 - using 'read','write','open','close','mmap','msync','munmap'
 *
 *	 - Command line : 
 *	         
 *	         disk_read_vs_mmap <kbsize> 
 *
 *	         kbsize : chunk size in KB (0 == default = 1Kb)
 *
 * 
 * ***************************************************************/

#include "perftest.h"

int disk_read_vs_mmap(int kbsize);

int main(int argc,char **argv)
{
	int kbsize=0;

	/* read kbsize from argv */

	if(argc<2)
	{
		printf("\n Usage :   disk_read_vs_mmap <kbsize> \n\n kbsize : chunk size in KB (0 == default = 1KB)\n\n ");
		return(-1);
	}

	kbsize = atoi(argv[1]);

	if(kbsize <=0) kbsize = 1;

	if(disk_read_vs_mmap(kbsize)<0)perror("Error in disk_read_vs_mmap\n");
	
	return(0);	
}


int disk_read_vs_mmap(int kbsize)
{
	int fd=0;
	int i,j,nbuff=0,n=0,off=0,err=0;
	char *data=NULL;
	double readtime=0,mmaptime=0,gtime=0,tread=0,tloop=0,twrite=0;
	void *startaddress=0;
	
	n = NN; // size in KB of target file
	nbuff = n/kbsize;
	
	data = (char*)malloc(kbsize*1024);

	/* do the timing for read,loop,write - if not explicitly
	 * then by profiling - this should be done... to see how much
	 * time is spent in each */


	/* Get timing for GetTime !!! */
	tread=0;tloop=0;twrite=0;
	gtime = GetTime(3);
	for(i=0;i<nbuff;i++)
	{
		GetTime(1);
		tread += GetTime(2);
		GetTime(1);
		tloop += GetTime(2);
		GetTime(1);
		twrite += GetTime(2);
	}
	gtime = GetTime(3) - gtime;
	
	printf("bufsize= %d KB   nbuff= %d   timers= %10.9lf  ",kbsize,nbuff,gtime);
	
	/* Read and Write the File using mmap,munmap */
	tread=0;tloop=0;twrite=0;
	fd = open("scratchfile",O_RDWR|O_SYNC);
	mmaptime = GetTime(3);
	for(i=0;i<nbuff;i++)
	{
		GetTime(1);
		startaddress = mmap(0,kbsize*1024,PROT_READ|PROT_WRITE,MAP_SHARED,fd,0);
		tread += GetTime(2);
		
		
		GetTime(1);
		for(j=0;j<kbsize*1024;j++) *((char*)(startaddress)+j) = ((*((char*)(startaddress)+j))+5)%250;
		tloop += GetTime(2);
		
		
		GetTime(1);
		err = munmap(startaddress,kbsize*1024);
		lseek(fd,kbsize*1024,SEEK_CUR);
		twrite += GetTime(2);
	}
	mmaptime = GetTime(3) - mmaptime;
	close(fd);

	printf("mmaptotal= %10.9lf   mprd= %10.9lf  mlp= %10.9lf  mwr= %10.9lf   ",mmaptime,tread,tloop,twrite);

	
	/* Read and Write the File using read,write */
	tread=0;tloop=0;twrite=0;
	fd = open("scratchfile",O_RDWR|O_SYNC);
	off=0;
	readtime = GetTime(3);
	for(i=0;i<nbuff;i++)
	{
		GetTime(1);
		read(fd,data,kbsize*1024);
		tread += GetTime(2);

		
		GetTime(1);
		for(j=0;j<kbsize*1024;j++) data[j]=(data[j]+5)%250;
		tloop += GetTime(2);

		
		GetTime(1);
		lseek(fd,-1*kbsize*1024,SEEK_CUR);
		write(fd,data,kbsize*1024);
		twrite += GetTime(2);
	}
	readtime = GetTime(3)-readtime;
	close(fd);

	printf("synchtotal= %10.9lf   rprd= %10.9lf  rlp= %10.9lf  rwr= %10.9lf\n",readtime,tread,tloop,twrite);

	free(data);
	


	return(0);
	
}

