/*****************************************************************
 * 
 * arithmetic_cnt.c : 
 * 
 *	 - Command line : 
 *	         
 *		arithmetic_cnt
 * 
 * ***************************************************************/

#include "perftest.h"

int arithmetic_cnt();

int main(int argc,char **argv)
{

	if(arithmetic_cnt()<0)perror("Error in disk_read_vs_mmap\n");
	
	return(0);	
}


int arithmetic_cnt()
{

	double difftime=0;
	int N;
	int acc=0,inc=0,i,ferr=0,stat=0;
	float facc=0,finc=0;
	int fd=0;
	int *data=NULL;
	FILE *fp=NULL;
	
	inc=5;
	finc = 3.14;
	N=100000000;
	
	/* Integer Addition */
	GetTime(1);
	for(i=0;i<N;i++)
		acc = i + inc;
	difftime = GetTime(2);
	printf("Int Add     %lf MOps/sec\n",N/(difftime*1e+6));
	
	/* Integer Subtraction */
	GetTime(1);
	for(i=0;i<N;i++)
		acc = i - inc;
	difftime = GetTime(2);
	printf("Int Sub     %lf MOps/sec\n",N/(difftime*1e+6));
	
	/* Integer Mult */
	acc=1;
	GetTime(1);
	for(i=0;i<N;i++)
		acc = i * inc;
	difftime = GetTime(2);
	printf("Int Mult    %lf MOps/sec\n",N/(difftime*1e+6));

	/* Integer Division */
	GetTime(1);
	for(i=0;i<N;i++)
		acc = i / inc;
	difftime = GetTime(2);
	printf("Int Div     %lf MOps/sec\n",N/(difftime*1e+6));

	/* Float Addition */
	GetTime(1);
	for(i=0;i<N;i++)
		facc = i + finc;
	difftime = GetTime(2);
	printf("Float Add   %lf MOps/sec\n",N/(difftime*1e+6));

	/* Float Subtraction */
	GetTime(1);
	for(i=0;i<N;i++)
		facc = i - finc;
	difftime = GetTime(2);
	printf("Float Sub   %lf MOps/sec\n",N/(difftime*1e+6));

	/* Float Mult */
	facc=1.0;
	GetTime(1);
	for(i=0;i<N;i++)
		facc = i * finc;
	difftime = GetTime(2);
	printf("Float Mult  %lf MOps/sec\n",N/(difftime*1e+6));

	/* Float Division */
	GetTime(1);
	for(i=0;i<N;i++)
		facc = i / finc;
	difftime = GetTime(2);
	printf("Float Div   %lf MOps/sec\n",N/(difftime*1e+6));

	/* Call getpid() */
	GetTime(1);
	for(i=0;i<N/100;i++) getpid();
	difftime = GetTime(2);
	printf("Call Getpid %lf MOps/sec\n",N/(100*difftime*1e+6));

	/* File Open Close - fopen-fclose */
	fp=fopen("temp","w");
	fclose(fp);
	GetTime(1);
	for(i=0;i<N/100;i++)
	{
		fp=fopen("temp","w");
		fclose(fp);
	}
	difftime = GetTime(2);
	printf("File Open-Close-fopen-fclose  %lf MOps/sec\n",N/(100*difftime*1e+6));
	
	/* File Open Close - open-close */
	GetTime(1);
	for(i=0;i<N/100;i++)
	{
		fd = open("temp",O_RDWR|O_SYNC|O_CREAT);
		close(fd);
	}
	difftime = GetTime(2);
	printf("File Open-Close-open-close  %lf MOps/sec\n",N/(100*difftime*1e+6));

	/* File Create Delete */
	GetTime(1);
	for(i=0;i<N/100;i++)
	{
		fd = open("temp",O_RDWR|O_SYNC|O_CREAT);
		close(fd);
		unlink("temp");
	}
	difftime = GetTime(2);
	printf("File Create Delete  %lf MOps/sec\n",N/(100*difftime*1e+6));


	/* mem malloc free */
	GetTime(1);
	for(i=0;i<N/10;i++)
	{
		data=(int*)malloc(4);
		free(data);
	}
	difftime = GetTime(2);
	printf("Malloc Free   %lf MOps/sec\n",N/(10*difftime*1e+6));

	/* forking */
	GetTime(1);
	for(i=0;i<N/1000;i++)
	{
		ferr=fork();
		if(ferr==0)exit(0);
		else wait(&stat);
	}
	difftime = GetTime(2);
	printf("Process Fork   %lf MOps/sec\n",N/(1000*difftime*1e+6));
	

	fprintf(stderr,"%d %lf\n",acc,facc);

	
	return(0);
	
}

